/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractHealthIndicator
implements HealthIndicator {
    private static final String NO_MESSAGE = null;
    private static final String DEFAULT_MESSAGE = "Health check failed";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Function<Exception, String> healthCheckFailedMessage;

    protected AbstractHealthIndicator() {
        this(NO_MESSAGE);
    }

    protected AbstractHealthIndicator(String healthCheckFailedMessage) {
        this.healthCheckFailedMessage = ex -> healthCheckFailedMessage;
    }

    protected AbstractHealthIndicator(Function<Exception, String> healthCheckFailedMessage) {
        Assert.notNull(healthCheckFailedMessage, (String)"'healthCheckFailedMessage' must not be null");
        this.healthCheckFailedMessage = healthCheckFailedMessage;
    }

    @Override
    public final Health health() {
        Health.Builder builder = new Health.Builder();
        try {
            this.doHealthCheck(builder);
        }
        catch (Exception ex) {
            builder.down(ex);
        }
        this.logExceptionIfPresent(builder.getException());
        return builder.build();
    }

    private void logExceptionIfPresent(Throwable throwable) {
        if (throwable != null && this.logger.isWarnEnabled()) {
            String string;
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                string = this.healthCheckFailedMessage.apply(ex);
            } else {
                string = null;
            }
            String message = string;
            this.logger.warn((Object)(StringUtils.hasText(message) ? message : DEFAULT_MESSAGE), throwable);
        }
    }

    protected abstract void doHealthCheck(Health.Builder var1) throws Exception;
}

