/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.hazelcast.testcontainers;

import com.hazelcast.client.config.ClientConfig;
import java.util.Map;
import org.springframework.boot.hazelcast.autoconfigure.HazelcastConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class HazelcastContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, HazelcastConnectionDetails> {
    private static final int DEFAULT_PORT = 5701;
    private static final String CLUSTER_NAME_ENV = "HZ_CLUSTERNAME";

    HazelcastContainerConnectionDetailsFactory() {
        super("hazelcast/hazelcast", new String[]{"com.hazelcast.client.config.ClientConfig"});
    }

    protected HazelcastConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new HazelcastContainerConnectionDetails(source);
    }

    private static final class HazelcastContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements HazelcastConnectionDetails {
        private HazelcastContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        @Override
        public ClientConfig getClientConfig() {
            ClientConfig config = new ClientConfig();
            Container container = this.getContainer();
            Map env = container.getEnvMap();
            String clusterName = (String)env.get(HazelcastContainerConnectionDetailsFactory.CLUSTER_NAME_ENV);
            if (clusterName != null) {
                config.setClusterName(clusterName);
            }
            config.getNetworkConfig().addAddress(new String[]{container.getHost() + ":" + container.getMappedPort(5701)});
            return config;
        }
    }
}

