/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.springframework.util.StringUtils;

public class LaunchScriptConfiguration
implements Serializable {
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern LINE_FEED_PATTERN = Pattern.compile("\n");
    private final Map<String, String> properties = new TreeMap<String, String>();
    private File script;

    public LaunchScriptConfiguration() {
    }

    LaunchScriptConfiguration(AbstractArchiveTask archiveTask) {
        Project project = archiveTask.getProject();
        String baseName = (String)archiveTask.getArchiveBaseName().get();
        this.putIfMissing(this.properties, "initInfoProvides", baseName);
        this.putIfMissing(this.properties, "initInfoShortDescription", this.removeLineBreaks(project.getDescription()), baseName);
        this.putIfMissing(this.properties, "initInfoDescription", this.augmentLineBreaks(project.getDescription()), baseName);
    }

    @Input
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void properties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getScript() {
        return this.script;
    }

    public void setScript(File script) {
        this.script = script;
    }

    private String removeLineBreaks(String string) {
        return string != null ? WHITE_SPACE_PATTERN.matcher(string).replaceAll(" ") : null;
    }

    private String augmentLineBreaks(String string) {
        return string != null ? LINE_FEED_PATTERN.matcher(string).replaceAll("\n#  ") : null;
    }

    private void putIfMissing(Map<String, String> properties, String key, String ... valueCandidates) {
        if (!properties.containsKey(key)) {
            for (String candidate : valueCandidates) {
                if (!StringUtils.hasLength((String)candidate)) continue;
                properties.put(key, candidate);
                return;
            }
        }
    }
}

