/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.springframework.boot.loader.tools.MainClassFinder;

@DisableCachingByDefault(because="Not worth caching")
public class ResolveMainClassName
extends DefaultTask {
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private final RegularFileProperty outputFile = this.getProject().getObjects().fileProperty();
    private final Property<String> configuredMainClass = this.getProject().getObjects().property(String.class);
    private FileCollection classpath;

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.setClasspath((Object)classpath);
    }

    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Input
    @Optional
    public Property<String> getConfiguredMainClassName() {
        return this.configuredMainClass;
    }

    @TaskAction
    void resolveAndStoreMainClassName() throws IOException {
        File outputFile = (File)this.outputFile.getAsFile().get();
        outputFile.getParentFile().mkdirs();
        String mainClassName = this.resolveMainClassName();
        Files.writeString(outputFile.toPath(), (CharSequence)mainClassName, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private String resolveMainClassName() {
        String configuredMainClass = (String)this.configuredMainClass.getOrNull();
        if (configuredMainClass != null) {
            return configuredMainClass;
        }
        return this.getClasspath().filter(File::isDirectory).getFiles().stream().map(this::findMainClass).filter(Objects::nonNull).findFirst().orElse("");
    }

    private String findMainClass(File file) {
        try {
            return MainClassFinder.findSingleMainClass((File)file, (String)SPRING_BOOT_APPLICATION_CLASS_NAME);
        }
        catch (IOException ex) {
            return null;
        }
    }

    Provider<String> readMainClassName() {
        String classpath = this.getClasspath().filter(File::isDirectory).getFiles().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
        return this.outputFile.map((Transformer)new ClassNameReader(classpath));
    }

    private static final class ClassNameReader
    implements Transformer<String, RegularFile> {
        private final String classpath;

        private ClassNameReader(String classpath) {
            this.classpath = classpath;
        }

        public String transform(RegularFile file) {
            if (file.getAsFile().length() == 0L) {
                throw new InvalidUserDataException("Main class name has not been configured and it could not be resolved from classpath " + this.classpath);
            }
            Path output = file.getAsFile().toPath();
            try {
                return Files.readString(output);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to read main class name from '" + String.valueOf(output) + "'");
            }
        }
    }
}

