/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopyActionProcessingStream;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.util.GradleVersion;
import org.springframework.boot.gradle.tasks.bundling.DefaultTimeZoneOffset;
import org.springframework.boot.gradle.tasks.bundling.LaunchScriptConfiguration;
import org.springframework.boot.gradle.tasks.bundling.LayerResolver;
import org.springframework.boot.gradle.tasks.bundling.LoaderZipEntries;
import org.springframework.boot.gradle.tasks.bundling.ResolvedDependencies;
import org.springframework.boot.gradle.tasks.bundling.ZipCompression;
import org.springframework.boot.loader.tools.DefaultLaunchScript;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.loader.tools.JarModeLibrary;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.boot.loader.tools.LayersIndex;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCoordinates;
import org.springframework.boot.loader.tools.LoaderImplementation;
import org.springframework.boot.loader.tools.NativeImageArgFile;
import org.springframework.boot.loader.tools.ReachabilityMetadataProperties;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

class BootZipCopyAction
implements CopyAction {
    static final long CONSTANT_TIME_FOR_ZIP_ENTRIES = OffsetDateTime.of(1980, 2, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant().toEpochMilli();
    private static final Pattern REACHABILITY_METADATA_PROPERTIES_LOCATION_PATTERN = Pattern.compile("META-INF/native-image/%s/%s/%s/reachability-metadata.properties".formatted(".*", ".*", ".*"));
    private final File output;
    private final Manifest manifest;
    private final boolean preserveFileTimestamps;
    private final Integer dirMode;
    private final Integer fileMode;
    private final boolean includeDefaultLoader;
    private final String jarmodeToolsLocation;
    private final Spec<FileTreeElement> requiresUnpack;
    private final Spec<FileTreeElement> exclusions;
    private final LaunchScriptConfiguration launchScript;
    private final Spec<FileCopyDetails> librarySpec;
    private final Function<FileCopyDetails, ZipCompression> compressionResolver;
    private final String encoding;
    private final ResolvedDependencies resolvedDependencies;
    private final boolean supportsSignatureFile;
    private final LayerResolver layerResolver;
    private final LoaderImplementation loaderImplementation;

    BootZipCopyAction(File output, Manifest manifest, boolean preserveFileTimestamps, Integer dirMode, Integer fileMode, boolean includeDefaultLoader, String jarmodeToolsLocation, Spec<FileTreeElement> requiresUnpack, Spec<FileTreeElement> exclusions, LaunchScriptConfiguration launchScript, Spec<FileCopyDetails> librarySpec, Function<FileCopyDetails, ZipCompression> compressionResolver, String encoding, ResolvedDependencies resolvedDependencies, boolean supportsSignatureFile, LayerResolver layerResolver, LoaderImplementation loaderImplementation) {
        this.output = output;
        this.manifest = manifest;
        this.preserveFileTimestamps = preserveFileTimestamps;
        this.dirMode = dirMode;
        this.fileMode = fileMode;
        this.includeDefaultLoader = includeDefaultLoader;
        this.jarmodeToolsLocation = jarmodeToolsLocation;
        this.requiresUnpack = requiresUnpack;
        this.exclusions = exclusions;
        this.launchScript = launchScript;
        this.librarySpec = librarySpec;
        this.compressionResolver = compressionResolver;
        this.encoding = encoding;
        this.resolvedDependencies = resolvedDependencies;
        this.supportsSignatureFile = supportsSignatureFile;
        this.layerResolver = layerResolver;
        this.loaderImplementation = loaderImplementation;
    }

    public WorkResult execute(CopyActionProcessingStream copyActions) {
        try {
            this.writeArchive(copyActions);
            return WorkResults.didWork((boolean)true);
        }
        catch (IOException ex) {
            throw new GradleException("Failed to create " + this.output, (Throwable)ex);
        }
    }

    private void writeArchive(CopyActionProcessingStream copyActions) throws IOException {
        FileOutputStream output = new FileOutputStream(this.output);
        try {
            this.writeArchive(copyActions, output);
        }
        finally {
            this.closeQuietly(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeArchive(CopyActionProcessingStream copyActions, OutputStream output) throws IOException {
        ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream(output);
        this.writeLaunchScriptIfNecessary(zipOutput);
        try {
            this.setEncodingIfNecessary(zipOutput);
            Processor processor = new Processor(zipOutput);
            copyActions.process(processor::process);
            processor.finish();
        }
        finally {
            this.closeQuietly((OutputStream)zipOutput);
        }
    }

    private void writeLaunchScriptIfNecessary(ZipArchiveOutputStream outputStream) {
        if (this.launchScript == null) {
            return;
        }
        try {
            File file = this.launchScript.getScript();
            Map<String, String> properties = this.launchScript.getProperties();
            outputStream.writePreamble(new DefaultLaunchScript(file, properties).toByteArray());
            this.output.setExecutable(true);
        }
        catch (IOException ex) {
            throw new GradleException("Failed to write launch script to " + this.output, (Throwable)ex);
        }
    }

    private void setEncodingIfNecessary(ZipArchiveOutputStream zipOutputStream) {
        if (this.encoding != null) {
            zipOutputStream.setEncoding(this.encoding);
        }
    }

    private void closeQuietly(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class Processor {
        private final ZipArchiveOutputStream out;
        private final LayersIndex layerIndex;
        private LoaderZipEntries.WrittenEntries writtenLoaderEntries;
        private final Set<String> writtenDirectories = new LinkedHashSet<String>();
        private final Map<String, FileCopyDetails> writtenLibraries = new LinkedHashMap<String, FileCopyDetails>();
        private final Map<String, FileCopyDetails> reachabilityMetadataProperties = new HashMap<String, FileCopyDetails>();

        Processor(ZipArchiveOutputStream out) {
            this.out = out;
            this.layerIndex = BootZipCopyAction.this.layerResolver != null ? new LayersIndex(BootZipCopyAction.this.layerResolver.getLayers()) : null;
        }

        void process(FileCopyDetails details) {
            if (this.skipProcessing(details)) {
                return;
            }
            try {
                this.writeLoaderEntriesIfNecessary(details);
                if (details.isDirectory()) {
                    this.processDirectory(details);
                } else {
                    this.processFile(details);
                }
            }
            catch (IOException ex) {
                throw new GradleException("Failed to add " + details + " to " + BootZipCopyAction.this.output, (Throwable)ex);
            }
        }

        private boolean skipProcessing(FileCopyDetails details) {
            return BootZipCopyAction.this.exclusions.isSatisfiedBy((Object)details) || this.writtenLoaderEntries != null && this.writtenLoaderEntries.isWrittenDirectory((FileTreeElement)details);
        }

        private void processDirectory(FileCopyDetails details) throws IOException {
            String name = details.getRelativePath().getPathString();
            ZipArchiveEntry entry = new ZipArchiveEntry(name + "/");
            this.prepareEntry(entry, name, this.getTime(details), this.getFileMode(details));
            this.out.putArchiveEntry(entry);
            this.out.closeArchiveEntry();
            this.writtenDirectories.add(name);
        }

        private void processFile(FileCopyDetails details) throws IOException {
            String name = details.getRelativePath().getPathString();
            ZipArchiveEntry entry = new ZipArchiveEntry(name);
            this.prepareEntry(entry, name, this.getTime(details), this.getFileMode(details));
            ZipCompression compression = BootZipCopyAction.this.compressionResolver.apply(details);
            if (compression == ZipCompression.STORED) {
                this.prepareStoredEntry(details, entry);
            }
            this.out.putArchiveEntry(entry);
            details.copyTo((OutputStream)this.out);
            this.out.closeArchiveEntry();
            if (BootZipCopyAction.this.librarySpec.isSatisfiedBy((Object)details)) {
                this.writtenLibraries.put(name, details);
            }
            if (REACHABILITY_METADATA_PROPERTIES_LOCATION_PATTERN.matcher(name).matches()) {
                this.reachabilityMetadataProperties.put(name, details);
            }
            if (BootZipCopyAction.this.layerResolver != null) {
                Layer layer = BootZipCopyAction.this.layerResolver.getLayer(details);
                this.layerIndex.add(layer, name);
            }
        }

        private void writeParentDirectoriesIfNecessary(String name, Long time) throws IOException {
            String parentDirectory = this.getParentDirectory(name);
            if (parentDirectory != null && this.writtenDirectories.add(parentDirectory)) {
                ZipArchiveEntry entry = new ZipArchiveEntry(parentDirectory + "/");
                this.prepareEntry(entry, parentDirectory, time, this.getDirMode());
                this.out.putArchiveEntry(entry);
                this.out.closeArchiveEntry();
            }
        }

        private String getParentDirectory(String name) {
            int lastSlash = name.lastIndexOf(47);
            if (lastSlash == -1) {
                return null;
            }
            return name.substring(0, lastSlash);
        }

        void finish() throws IOException {
            this.writeLoaderEntriesIfNecessary(null);
            this.writeJarToolsIfNecessary();
            this.writeSignatureFileIfNecessary();
            this.writeClassPathIndexIfNecessary();
            this.writeNativeImageArgFileIfNecessary();
            this.writeLayersIndexIfNecessary();
        }

        private void writeLoaderEntriesIfNecessary(FileCopyDetails details) throws IOException {
            if (!BootZipCopyAction.this.includeDefaultLoader || this.writtenLoaderEntries != null) {
                return;
            }
            if (this.isInMetaInf(details)) {
                return;
            }
            LoaderZipEntries loaderEntries = new LoaderZipEntries(this.getTime(), this.getDirMode(), this.getFileMode(), BootZipCopyAction.this.loaderImplementation);
            this.writtenLoaderEntries = loaderEntries.writeTo(this.out);
            if (BootZipCopyAction.this.layerResolver != null) {
                for (String name : this.writtenLoaderEntries.getFiles()) {
                    Layer layer = BootZipCopyAction.this.layerResolver.getLayer(name);
                    this.layerIndex.add(layer, name);
                }
            }
        }

        private boolean isInMetaInf(FileCopyDetails details) {
            if (details == null) {
                return false;
            }
            String[] segments = details.getRelativePath().getSegments();
            return segments.length > 0 && "META-INF".equals(segments[0]);
        }

        private void writeJarToolsIfNecessary() throws IOException {
            if (BootZipCopyAction.this.jarmodeToolsLocation != null) {
                this.writeJarModeLibrary(BootZipCopyAction.this.jarmodeToolsLocation, JarModeLibrary.TOOLS);
            }
        }

        private void writeJarModeLibrary(String location, JarModeLibrary library) throws IOException {
            String name = location + library.getName();
            this.writeEntry(name, ZipEntryContentWriter.fromInputStream(library.openStream()), false, entry -> this.prepareStoredEntry(library.openStream(), entry));
            if (BootZipCopyAction.this.layerResolver != null) {
                Layer layer = BootZipCopyAction.this.layerResolver.getLayer((Library)library);
                this.layerIndex.add(layer, name);
            }
        }

        private void writeSignatureFileIfNecessary() throws IOException {
            if (BootZipCopyAction.this.supportsSignatureFile && this.hasSignedLibrary()) {
                this.writeEntry("META-INF/BOOT.SF", out -> {}, false);
            }
        }

        private boolean hasSignedLibrary() throws IOException {
            for (FileCopyDetails writtenLibrary : this.writtenLibraries.values()) {
                if (!FileUtils.isSignedJarFile((File)writtenLibrary.getFile())) continue;
                return true;
            }
            return false;
        }

        private void writeClassPathIndexIfNecessary() throws IOException {
            Attributes manifestAttributes = BootZipCopyAction.this.manifest.getAttributes();
            String classPathIndex = (String)manifestAttributes.get((Object)"Spring-Boot-Classpath-Index");
            if (classPathIndex != null) {
                Set<String> libraryNames = this.writtenLibraries.keySet();
                List<String> lines = libraryNames.stream().map(line -> "- \"" + line + "\"").toList();
                ZipEntryContentWriter writer = ZipEntryContentWriter.fromLines(BootZipCopyAction.this.encoding, lines);
                this.writeEntry(classPathIndex, writer, true);
            }
        }

        private void writeNativeImageArgFileIfNecessary() throws IOException {
            LinkedHashSet<String> excludes = new LinkedHashSet<String>();
            for (Map.Entry<String, FileCopyDetails> entry : this.writtenLibraries.entrySet()) {
                ResolvedDependencies.DependencyDescriptor descriptor = BootZipCopyAction.this.resolvedDependencies.find(entry.getValue().getFile());
                LibraryCoordinates coordinates = descriptor != null ? descriptor.getCoordinates() : null;
                FileCopyDetails propertiesFile = coordinates != null ? this.reachabilityMetadataProperties.get(ReachabilityMetadataProperties.getLocation((LibraryCoordinates)coordinates)) : null;
                if (propertiesFile == null) continue;
                InputStream inputStream = propertiesFile.open();
                try {
                    ReachabilityMetadataProperties properties = ReachabilityMetadataProperties.fromInputStream((InputStream)inputStream);
                    if (!properties.isOverridden()) continue;
                    excludes.add(entry.getKey());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            NativeImageArgFile argFile = new NativeImageArgFile(excludes);
            argFile.writeIfNecessary(lines -> {
                ZipEntryContentWriter writer = ZipEntryContentWriter.fromLines(BootZipCopyAction.this.encoding, lines);
                this.writeEntry("META-INF/native-image/argfile", writer, true);
            });
        }

        private void writeLayersIndexIfNecessary() throws IOException {
            if (BootZipCopyAction.this.layerResolver != null) {
                Attributes manifestAttributes = BootZipCopyAction.this.manifest.getAttributes();
                String name = (String)manifestAttributes.get((Object)"Spring-Boot-Layers-Index");
                Assert.state((boolean)StringUtils.hasText((String)name), (String)"Missing layer index manifest attribute");
                Layer layer = BootZipCopyAction.this.layerResolver.getLayer(name);
                this.layerIndex.add(layer, name);
                this.writeEntry(name, arg_0 -> ((LayersIndex)this.layerIndex).writeTo(arg_0), false);
            }
        }

        private void writeEntry(String name, ZipEntryContentWriter entryWriter, boolean addToLayerIndex) throws IOException {
            this.writeEntry(name, entryWriter, addToLayerIndex, ZipEntryCustomizer.NONE);
        }

        private void writeEntry(String name, ZipEntryContentWriter entryWriter, boolean addToLayerIndex, ZipEntryCustomizer entryCustomizer) throws IOException {
            ZipArchiveEntry entry = new ZipArchiveEntry(name);
            this.prepareEntry(entry, name, this.getTime(), this.getFileMode());
            entryCustomizer.customize(entry);
            this.out.putArchiveEntry(entry);
            entryWriter.writeTo(this.out);
            this.out.closeArchiveEntry();
            if (addToLayerIndex && BootZipCopyAction.this.layerResolver != null) {
                Layer layer = BootZipCopyAction.this.layerResolver.getLayer(name);
                this.layerIndex.add(layer, name);
            }
        }

        private void prepareEntry(ZipArchiveEntry entry, String name, Long time, int mode) throws IOException {
            this.writeParentDirectoriesIfNecessary(name, time);
            entry.setUnixMode(mode);
            if (time != null) {
                entry.setTime(DefaultTimeZoneOffset.INSTANCE.removeFrom(time));
            }
        }

        private void prepareStoredEntry(FileCopyDetails details, ZipArchiveEntry archiveEntry) throws IOException {
            this.prepareStoredEntry(details.open(), archiveEntry);
            if (BootZipCopyAction.this.requiresUnpack.isSatisfiedBy((Object)details)) {
                archiveEntry.setComment("UNPACK:" + FileUtils.sha1Hash((File)details.getFile()));
            }
        }

        private void prepareStoredEntry(InputStream input, ZipArchiveEntry archiveEntry) throws IOException {
            new CrcAndSize(input).setUpStoredEntry(archiveEntry);
        }

        private Long getTime() {
            return this.getTime(null);
        }

        private Long getTime(FileCopyDetails details) {
            if (!BootZipCopyAction.this.preserveFileTimestamps) {
                return CONSTANT_TIME_FOR_ZIP_ENTRIES;
            }
            if (details != null) {
                return details.getLastModified();
            }
            return null;
        }

        private int getDirMode() {
            return BootZipCopyAction.this.dirMode != null ? BootZipCopyAction.this.dirMode : 16877;
        }

        private int getFileMode() {
            return BootZipCopyAction.this.fileMode != null ? BootZipCopyAction.this.fileMode : 33188;
        }

        private int getFileMode(FileCopyDetails details) {
            return BootZipCopyAction.this.fileMode != null ? BootZipCopyAction.this.fileMode : 0x8000 | this.getPermissions(details);
        }

        private int getPermissions(FileCopyDetails details) {
            return GradleVersion.current().compareTo(GradleVersion.version((String)"8.3")) >= 0 ? details.getPermissions().toUnixNumeric() : this.getMode(details);
        }

        private int getMode(FileCopyDetails details) {
            return details.getMode();
        }
    }

    private static class CrcAndSize {
        private static final int BUFFER_SIZE = 32768;
        private final CRC32 crc = new CRC32();
        private long size;

        CrcAndSize(InputStream inputStream) throws IOException {
            try (InputStream inputStream2 = inputStream;){
                this.load(inputStream);
            }
        }

        private void load(InputStream inputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.crc.update(buffer, 0, bytesRead);
                this.size += (long)bytesRead;
            }
        }

        void setUpStoredEntry(ZipArchiveEntry entry) {
            entry.setSize(this.size);
            entry.setCompressedSize(this.size);
            entry.setCrc(this.crc.getValue());
            entry.setMethod(0);
        }
    }

    @FunctionalInterface
    private static interface ZipEntryContentWriter {
        public void writeTo(ZipArchiveOutputStream var1) throws IOException;

        public static ZipEntryContentWriter fromInputStream(InputStream in) {
            return out -> {
                StreamUtils.copy((InputStream)in, (OutputStream)out);
                in.close();
            };
        }

        public static ZipEntryContentWriter fromLines(String encoding, Collection<String> lines) {
            return out -> {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
                for (String line : lines) {
                    writer.append(line).append("\n");
                }
                writer.flush();
            };
        }
    }

    @FunctionalInterface
    private static interface ZipEntryCustomizer {
        public static final ZipEntryCustomizer NONE = entry -> {};

        public void customize(ZipArchiveEntry var1) throws IOException;
    }
}

