/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.buildtools.gradle.NativeImagePlugin;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.graalvm.buildtools.gradle.dsl.NativeImageOptions;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.springframework.boot.gradle.plugin.PluginApplicationAction;
import org.springframework.boot.gradle.plugin.SpringBootAotPlugin;
import org.springframework.boot.gradle.tasks.bundling.BootBuildImage;
import org.springframework.boot.gradle.tasks.bundling.BootJar;

class NativeImagePluginAction
implements PluginApplicationAction {
    NativeImagePluginAction() {
    }

    @Override
    public Class<? extends Plugin<? extends Project>> getPluginClass() {
        return NativeImagePlugin.class;
    }

    public void execute(Project project) {
        project.getPlugins().apply(SpringBootAotPlugin.class);
        project.getPlugins().withType(JavaPlugin.class).all(plugin -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            SourceSetContainer sourceSets = javaPluginExtension.getSourceSets();
            GraalVMExtension graalVmExtension = this.configureGraalVmExtension(project);
            this.configureMainNativeBinaryClasspath(project, sourceSets, graalVmExtension);
            this.configureTestNativeBinaryClasspath(sourceSets, graalVmExtension);
            this.copyReachabilityMetadataToBootJar(project);
            this.configureBootBuildImageToProduceANativeImage(project);
            this.configureJarManifestNativeAttribute(project);
        });
    }

    private void configureMainNativeBinaryClasspath(Project project, SourceSetContainer sourceSets, GraalVMExtension graalVmExtension) {
        FileCollection runtimeClasspath = ((SourceSet)sourceSets.getByName("aot")).getRuntimeClasspath();
        ((NativeImageOptions)graalVmExtension.getBinaries().getByName("main")).classpath(new Object[]{runtimeClasspath});
        Configuration nativeImageClasspath = project.getConfigurations().getByName("nativeImageClasspath");
        nativeImageClasspath.setExtendsFrom(this.removeDevelopmentOnly(nativeImageClasspath.getExtendsFrom()));
    }

    private Iterable<Configuration> removeDevelopmentOnly(Set<Configuration> configurations) {
        return configurations.stream().filter(this::isNotDevelopmentOnly).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private boolean isNotDevelopmentOnly(Configuration configuration) {
        return !"developmentOnly".equals(configuration.getName()) && !"testAndDevelopmentOnly".equals(configuration.getName());
    }

    private void configureTestNativeBinaryClasspath(SourceSetContainer sourceSets, GraalVMExtension graalVmExtension) {
        FileCollection runtimeClasspath = ((SourceSet)sourceSets.getByName("aotTest")).getRuntimeClasspath();
        ((NativeImageOptions)graalVmExtension.getBinaries().getByName("test")).classpath(new Object[]{runtimeClasspath});
    }

    private GraalVMExtension configureGraalVmExtension(Project project) {
        GraalVMExtension extension = (GraalVMExtension)project.getExtensions().getByType(GraalVMExtension.class);
        extension.getToolchainDetection().set((Object)false);
        return extension;
    }

    private void copyReachabilityMetadataToBootJar(Project project) {
        project.getTasks().named("bootJar", BootJar.class).configure(bootJar -> bootJar.from(new Object[]{project.getTasks().named("collectReachabilityMetadata")}));
    }

    private void configureBootBuildImageToProduceANativeImage(Project project) {
        project.getTasks().named("bootBuildImage", BootBuildImage.class).configure(bootBuildImage -> {
            bootBuildImage.getBuilder().convention((Object)"paketobuildpacks/builder-jammy-tiny:latest");
            bootBuildImage.getEnvironment().put((Object)"BP_NATIVE_IMAGE", (Object)"true");
        });
    }

    private void configureJarManifestNativeAttribute(Project project) {
        project.getTasks().named("bootJar", BootJar.class).configure(this::addNativeProcessedAttribute);
    }

    private void addNativeProcessedAttribute(BootJar bootJar) {
        bootJar.manifest(this::addNativeProcessedAttribute);
    }

    private void addNativeProcessedAttribute(Manifest manifest) {
        manifest.getAttributes().put((Object)"Spring-Boot-Native-Processed", (Object)true);
    }
}

