/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.util.ConfigureUtil;
import org.springframework.boot.buildpack.platform.docker.configuration.DockerConfiguration;

public class DockerSpec {
    private String host;
    private boolean tlsVerify;
    private String certPath;
    private final DockerRegistrySpec builderRegistry;
    private final DockerRegistrySpec publishRegistry;

    public DockerSpec() {
        this.builderRegistry = new DockerRegistrySpec();
        this.publishRegistry = new DockerRegistrySpec();
    }

    DockerSpec(DockerRegistrySpec builderRegistry, DockerRegistrySpec publishRegistry) {
        this.builderRegistry = builderRegistry;
        this.publishRegistry = publishRegistry;
    }

    @Input
    @Optional
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Input
    @Optional
    public Boolean isTlsVerify() {
        return this.tlsVerify;
    }

    public void setTlsVerify(boolean tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    @Input
    @Optional
    public String getCertPath() {
        return this.certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    @Nested
    public DockerRegistrySpec getBuilderRegistry() {
        return this.builderRegistry;
    }

    public void builderRegistry(Action<DockerRegistrySpec> action) {
        action.execute((Object)this.builderRegistry);
    }

    public void builderRegistry(Closure<?> closure) {
        this.builderRegistry((Action<DockerRegistrySpec>)ConfigureUtil.configureUsing(closure));
    }

    @Nested
    public DockerRegistrySpec getPublishRegistry() {
        return this.publishRegistry;
    }

    public void publishRegistry(Action<DockerRegistrySpec> action) {
        action.execute((Object)this.publishRegistry);
    }

    public void publishRegistry(Closure<?> closure) {
        this.publishRegistry((Action<DockerRegistrySpec>)ConfigureUtil.configureUsing(closure));
    }

    DockerConfiguration asDockerConfiguration() {
        DockerConfiguration dockerConfiguration = new DockerConfiguration();
        dockerConfiguration = this.customizeHost(dockerConfiguration);
        dockerConfiguration = this.customizeBuilderAuthentication(dockerConfiguration);
        dockerConfiguration = this.customizePublishAuthentication(dockerConfiguration);
        return dockerConfiguration;
    }

    private DockerConfiguration customizeHost(DockerConfiguration dockerConfiguration) {
        if (this.host != null) {
            return dockerConfiguration.withHost(this.host, this.tlsVerify, this.certPath);
        }
        return dockerConfiguration;
    }

    private DockerConfiguration customizeBuilderAuthentication(DockerConfiguration dockerConfiguration) {
        if (this.builderRegistry == null || this.builderRegistry.hasEmptyAuth()) {
            return dockerConfiguration;
        }
        if (this.builderRegistry.hasTokenAuth() && !this.builderRegistry.hasUserAuth()) {
            return dockerConfiguration.withBuilderRegistryTokenAuthentication(this.builderRegistry.getToken());
        }
        if (this.builderRegistry.hasUserAuth() && !this.builderRegistry.hasTokenAuth()) {
            return dockerConfiguration.withBuilderRegistryUserAuthentication(this.builderRegistry.getUsername(), this.builderRegistry.getPassword(), this.builderRegistry.getUrl(), this.builderRegistry.getEmail());
        }
        throw new GradleException("Invalid Docker builder registry configuration, either token or username/password must be provided");
    }

    private DockerConfiguration customizePublishAuthentication(DockerConfiguration dockerConfiguration) {
        if (this.publishRegistry == null || this.publishRegistry.hasEmptyAuth()) {
            return dockerConfiguration.withEmptyPublishRegistryAuthentication();
        }
        if (this.publishRegistry.hasTokenAuth() && !this.publishRegistry.hasUserAuth()) {
            return dockerConfiguration.withPublishRegistryTokenAuthentication(this.publishRegistry.getToken());
        }
        if (this.publishRegistry.hasUserAuth() && !this.publishRegistry.hasTokenAuth()) {
            return dockerConfiguration.withPublishRegistryUserAuthentication(this.publishRegistry.getUsername(), this.publishRegistry.getPassword(), this.publishRegistry.getUrl(), this.publishRegistry.getEmail());
        }
        throw new GradleException("Invalid Docker publish registry configuration, either token or username/password must be provided");
    }

    public static class DockerRegistrySpec {
        private String username;
        private String password;
        private String url;
        private String email;
        private String token;

        public DockerRegistrySpec() {
        }

        DockerRegistrySpec(String username, String password, String url, String email) {
            this.username = username;
            this.password = password;
            this.url = url;
            this.email = email;
        }

        DockerRegistrySpec(String token) {
            this.token = token;
        }

        @Input
        @Optional
        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        @Input
        @Optional
        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        @Input
        @Optional
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Input
        @Optional
        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        @Input
        @Optional
        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        boolean hasEmptyAuth() {
            return this.username == null && this.password == null && this.url == null && this.email == null && this.token == null;
        }

        boolean hasUserAuth() {
            return this.getUsername() != null && this.getPassword() != null;
        }

        boolean hasTokenAuth() {
            return this.getToken() != null;
        }
    }
}

