/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.postgres;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PostgresEnvironment {
    private final String username;
    private final String password;
    private final String database;

    PostgresEnvironment(Map<String, String> env) {
        this.username = env.getOrDefault("POSTGRES_USER", env.getOrDefault("POSTGRESQL_USER", "postgres"));
        this.password = this.extractPassword(env);
        this.database = env.getOrDefault("POSTGRES_DB", env.getOrDefault("POSTGRESQL_DB", this.username));
    }

    private String extractPassword(Map<String, String> env) {
        if (this.isUsingTrustHostAuthMethod(env)) {
            return null;
        }
        String password = env.getOrDefault("POSTGRES_PASSWORD", env.get("POSTGRESQL_PASSWORD"));
        Assert.state((boolean)StringUtils.hasLength((String)password), (String)"PostgreSQL password must be provided");
        return password;
    }

    private boolean isUsingTrustHostAuthMethod(Map<String, String> env) {
        String hostAuthMethod = env.get("POSTGRES_HOST_AUTH_METHOD");
        return "trust".equals(hostAuthMethod);
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

