/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.otlp;

import org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.logging.otlp.Transport;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class OpenTelemetryLoggingDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<OtlpLoggingConnectionDetails> {
    private static final String[] OPENTELEMETRY_IMAGE_NAMES = new String[]{"otel/opentelemetry-collector-contrib", "grafana/otel-lgtm"};
    private static final int OTLP_GRPC_PORT = 4317;
    private static final int OTLP_HTTP_PORT = 4318;

    OpenTelemetryLoggingDockerComposeConnectionDetailsFactory() {
        super(OPENTELEMETRY_IMAGE_NAMES, "org.springframework.boot.actuate.autoconfigure.logging.otlp.OtlpLoggingAutoConfiguration");
    }

    @Override
    protected OtlpLoggingConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OpenTelemetryLoggingDockerComposeConnectionDetails(source.getRunningService());
    }

    private static final class OpenTelemetryLoggingDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements OtlpLoggingConnectionDetails {
        private final String host;
        private final int grpcPort;
        private final int httpPort;

        private OpenTelemetryLoggingDockerComposeConnectionDetails(RunningService source) {
            super(source);
            this.host = source.host();
            this.grpcPort = source.ports().get(4317);
            this.httpPort = source.ports().get(4318);
        }

        public String getUrl(Transport transport) {
            int port = switch (transport) {
                default -> throw new IncompatibleClassChangeError();
                case Transport.HTTP -> this.httpPort;
                case Transport.GRPC -> this.grpcPort;
            };
            return "http://%s:%d/v1/logs".formatted(this.host, port);
        }
    }
}

