/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.mongo;

import com.mongodb.ConnectionString;
import org.springframework.boot.autoconfigure.mongo.MongoConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.mongo.MongoEnvironment;

class MongoDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<MongoConnectionDetails> {
    private static final String[] MONGODB_CONTAINER_NAMES = new String[]{"mongo", "bitnami/mongodb"};
    private static final int MONGODB_PORT = 27017;

    protected MongoDockerComposeConnectionDetailsFactory() {
        super(MONGODB_CONTAINER_NAMES, "com.mongodb.ConnectionString");
    }

    @Override
    protected MongoDockerComposeConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new MongoDockerComposeConnectionDetails(source.getRunningService());
    }

    static class MongoDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements MongoConnectionDetails {
        private final ConnectionString connectionString;

        MongoDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.connectionString = this.buildConnectionString(service);
        }

        private ConnectionString buildConnectionString(RunningService service) {
            MongoEnvironment environment = new MongoEnvironment(service.env());
            StringBuilder builder = new StringBuilder("mongodb://");
            if (environment.getUsername() != null) {
                builder.append(environment.getUsername());
                builder.append(":");
                builder.append(environment.getPassword() != null ? environment.getPassword() : "");
                builder.append("@");
            }
            builder.append(service.host());
            builder.append(":");
            builder.append(service.ports().get(27017));
            builder.append("/");
            builder.append(environment.getDatabase() != null ? environment.getDatabase() : "test");
            if (environment.getUsername() != null) {
                builder.append("?authSource=admin");
            }
            return new ConnectionString(builder.toString());
        }

        public ConnectionString getConnectionString() {
            return this.connectionString;
        }
    }
}

