/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.mysql;

import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class MySqlEnvironment {
    private final String username;
    private final String password;
    private final String database;

    MySqlEnvironment(Map<String, String> env) {
        this.username = env.getOrDefault("MYSQL_USER", "root");
        this.password = this.extractPassword(env);
        this.database = this.extractDatabase(env);
    }

    private String extractPassword(Map<String, String> env) {
        Assert.state((!env.containsKey("MYSQL_RANDOM_ROOT_PASSWORD") ? 1 : 0) != 0, (String)"MYSQL_RANDOM_ROOT_PASSWORD is not supported");
        boolean allowEmpty = env.containsKey("MYSQL_ALLOW_EMPTY_PASSWORD") || env.containsKey("ALLOW_EMPTY_PASSWORD");
        String password = env.get("MYSQL_PASSWORD");
        password = password != null ? password : env.get("MYSQL_ROOT_PASSWORD");
        Assert.state((StringUtils.hasLength((String)password) || allowEmpty ? 1 : 0) != 0, (String)"No MySQL password found");
        return password != null ? password : "";
    }

    private String extractDatabase(Map<String, String> env) {
        String database = env.get("MYSQL_DATABASE");
        Assert.state((database != null ? 1 : 0) != 0, (String)"No MYSQL_DATABASE defined");
        return database;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }
}

