/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import jakarta.servlet.Filter;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.autoconfigure.ConditionalOnEnabledDevTools;
import org.springframework.boot.devtools.autoconfigure.DevToolsProperties;
import org.springframework.boot.devtools.autoconfigure.RemoteDevToolsProperties;
import org.springframework.boot.devtools.autoconfigure.RemoteDevtoolsSecurityConfiguration;
import org.springframework.boot.devtools.remote.server.AccessManager;
import org.springframework.boot.devtools.remote.server.Dispatcher;
import org.springframework.boot.devtools.remote.server.DispatcherFilter;
import org.springframework.boot.devtools.remote.server.HandlerMapper;
import org.springframework.boot.devtools.remote.server.HttpHeaderAccessManager;
import org.springframework.boot.devtools.remote.server.HttpStatusHandler;
import org.springframework.boot.devtools.remote.server.UrlHandlerMapper;
import org.springframework.boot.devtools.restart.server.DefaultSourceDirectoryUrlFilter;
import org.springframework.boot.devtools.restart.server.HttpRestartServer;
import org.springframework.boot.devtools.restart.server.HttpRestartServerHandler;
import org.springframework.boot.devtools.restart.server.SourceDirectoryUrlFilter;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.log.LogMessage;
import org.springframework.http.server.ServerHttpRequest;

@AutoConfiguration(afterName={"org.springframework.boot.security.autoconfigure.servlet.SecurityAutoConfiguration"})
@ConditionalOnEnabledDevTools
@ConditionalOnProperty(value={"spring.devtools.remote.secret"})
@ConditionalOnClass(value={Filter.class, ServerHttpRequest.class, ServerProperties.class})
@Import(value={RemoteDevtoolsSecurityConfiguration.class})
@EnableConfigurationProperties(value={ServerProperties.class, DevToolsProperties.class})
public class RemoteDevToolsAutoConfiguration {
    private static final Log logger = LogFactory.getLog(RemoteDevToolsAutoConfiguration.class);
    private final DevToolsProperties properties;

    public RemoteDevToolsAutoConfiguration(DevToolsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public AccessManager remoteDevToolsAccessManager() {
        RemoteDevToolsProperties remoteProperties = this.properties.getRemote();
        return new HttpHeaderAccessManager(remoteProperties.getSecretHeaderName(), remoteProperties.getSecret());
    }

    @Bean
    public HandlerMapper remoteDevToolsHealthCheckHandlerMapper(ServerProperties serverProperties) {
        HttpStatusHandler handler = new HttpStatusHandler();
        ServerProperties.Servlet servlet = serverProperties.getServlet();
        String servletContextPath = servlet.getContextPath() != null ? servlet.getContextPath() : "";
        return new UrlHandlerMapper(servletContextPath + this.properties.getRemote().getContextPath(), handler);
    }

    @Bean
    @ConditionalOnMissingBean
    public DispatcherFilter remoteDevToolsDispatcherFilter(AccessManager accessManager, Collection<HandlerMapper> mappers) {
        Dispatcher dispatcher = new Dispatcher(accessManager, mappers);
        return new DispatcherFilter(dispatcher);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(name={"spring.devtools.remote.restart.enabled"}, matchIfMissing=true)
    static class RemoteRestartConfiguration {
        RemoteRestartConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        SourceDirectoryUrlFilter remoteRestartSourceDirectoryUrlFilter() {
            return new DefaultSourceDirectoryUrlFilter();
        }

        @Bean
        @ConditionalOnMissingBean
        HttpRestartServer remoteRestartHttpRestartServer(SourceDirectoryUrlFilter sourceDirectoryUrlFilter) {
            return new HttpRestartServer(sourceDirectoryUrlFilter);
        }

        @Bean
        @ConditionalOnMissingBean(name={"remoteRestartHandlerMapper"})
        UrlHandlerMapper remoteRestartHandlerMapper(HttpRestartServer server, ServerProperties serverProperties, DevToolsProperties properties) {
            ServerProperties.Servlet servlet = serverProperties.getServlet();
            RemoteDevToolsProperties remote = properties.getRemote();
            String servletContextPath = servlet.getContextPath() != null ? servlet.getContextPath() : "";
            String url = servletContextPath + remote.getContextPath() + "/restart";
            logger.warn((Object)LogMessage.format((String)"Listening for remote restart updates on %s", (Object)url));
            HttpRestartServerHandler handler = new HttpRestartServerHandler(server);
            return new UrlHandlerMapper(url, handler);
        }
    }
}

