/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart.classloader;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFile;
import org.springframework.boot.devtools.restart.classloader.ClassLoaderFileRepository;
import org.springframework.util.Assert;

public class ClassLoaderFiles
implements ClassLoaderFileRepository,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, SourceDirectory> sourceDirectories;

    public ClassLoaderFiles() {
        this.sourceDirectories = new LinkedHashMap<String, SourceDirectory>();
    }

    public ClassLoaderFiles(ClassLoaderFiles classLoaderFiles) {
        Assert.notNull((Object)classLoaderFiles, (String)"ClassLoaderFiles must not be null");
        this.sourceDirectories = new LinkedHashMap<String, SourceDirectory>(classLoaderFiles.sourceDirectories);
    }

    public void addAll(ClassLoaderFiles files) {
        Assert.notNull((Object)files, (String)"Files must not be null");
        for (SourceDirectory directory : files.getSourceDirectories()) {
            for (Map.Entry<String, ClassLoaderFile> entry : directory.getFilesEntrySet()) {
                this.addFile(directory.getName(), entry.getKey(), entry.getValue());
            }
        }
    }

    public void addFile(String name, ClassLoaderFile file) {
        this.addFile("", name, file);
    }

    public void addFile(String sourceDirectory, String name, ClassLoaderFile file) {
        Assert.notNull((Object)sourceDirectory, (String)"SourceDirectory must not be null");
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)file, (String)"File must not be null");
        this.removeAll(name);
        this.getOrCreateSourceDirectory(sourceDirectory).add(name, file);
    }

    private void removeAll(String name) {
        for (SourceDirectory sourceDirectory : this.sourceDirectories.values()) {
            sourceDirectory.remove(name);
        }
    }

    protected final SourceDirectory getOrCreateSourceDirectory(String name) {
        SourceDirectory sourceDirectory = this.sourceDirectories.get(name);
        if (sourceDirectory == null) {
            sourceDirectory = new SourceDirectory(name);
            this.sourceDirectories.put(name, sourceDirectory);
        }
        return sourceDirectory;
    }

    public Collection<SourceDirectory> getSourceDirectories() {
        return Collections.unmodifiableCollection(this.sourceDirectories.values());
    }

    public int size() {
        int size = 0;
        for (SourceDirectory sourceDirectory : this.sourceDirectories.values()) {
            size += sourceDirectory.getFiles().size();
        }
        return size;
    }

    @Override
    public ClassLoaderFile getFile(String name) {
        for (SourceDirectory sourceDirectory : this.sourceDirectories.values()) {
            ClassLoaderFile file = sourceDirectory.get(name);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public static class SourceDirectory
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Map<String, ClassLoaderFile> files = new LinkedHashMap<String, ClassLoaderFile>();

        SourceDirectory(String name) {
            this.name = name;
        }

        public Set<Map.Entry<String, ClassLoaderFile>> getFilesEntrySet() {
            return this.files.entrySet();
        }

        protected final void add(String name, ClassLoaderFile file) {
            this.files.put(name, file);
        }

        protected final void remove(String name) {
            this.files.remove(name);
        }

        protected final ClassLoaderFile get(String name) {
            return this.files.get(name);
        }

        public String getName() {
            return this.name;
        }

        public Collection<ClassLoaderFile> getFiles() {
            return Collections.unmodifiableCollection(this.files.values());
        }
    }
}

