/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.livereload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.devtools.livereload.ConnectionClosedException;
import org.springframework.boot.devtools.livereload.ConnectionInputStream;
import org.springframework.boot.devtools.livereload.ConnectionOutputStream;
import org.springframework.boot.devtools.livereload.Frame;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.Base64Utils;

class Connection {
    private static final Log logger = LogFactory.getLog(Connection.class);
    private static final Pattern WEBSOCKET_KEY_PATTERN = Pattern.compile("^sec-websocket-key:(.*)$", 10);
    public static final String WEBSOCKET_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final Socket socket;
    private final ConnectionInputStream inputStream;
    private final ConnectionOutputStream outputStream;
    private final String header;
    private volatile boolean webSocket;
    private volatile boolean running = true;

    Connection(Socket socket, InputStream inputStream, OutputStream outputStream) throws IOException {
        this.socket = socket;
        this.inputStream = new ConnectionInputStream(inputStream);
        this.outputStream = new ConnectionOutputStream(outputStream);
        String header = this.inputStream.readHeader();
        logger.debug((Object)LogMessage.format((String)"Established livereload connection [%s]", (Object)header));
        this.header = header;
    }

    void run() throws Exception {
        String lowerCaseHeader = this.header.toLowerCase();
        if (lowerCaseHeader.contains("upgrade: websocket") && lowerCaseHeader.contains("sec-websocket-version: 13")) {
            this.runWebSocket();
        }
        if (lowerCaseHeader.contains("get /livereload.js")) {
            this.outputStream.writeHttp(this.getClass().getResourceAsStream("livereload.js"), "text/javascript");
        }
    }

    private void runWebSocket() throws Exception {
        this.webSocket = true;
        String accept = this.getWebsocketAcceptResponse();
        this.outputStream.writeHeaders("HTTP/1.1 101 Switching Protocols", "Upgrade: websocket", "Connection: Upgrade", "Sec-WebSocket-Accept: " + accept);
        new Frame("{\"command\":\"hello\",\"protocols\":[\"http://livereload.com/protocols/official-7\"],\"serverName\":\"spring-boot\"}").write(this.outputStream);
        while (this.running) {
            this.readWebSocketFrame();
        }
    }

    private void readWebSocketFrame() throws IOException {
        block5: {
            try {
                Frame frame = Frame.read(this.inputStream);
                if (frame.getType() == Frame.Type.PING) {
                    this.writeWebSocketFrame(new Frame(Frame.Type.PONG));
                    break block5;
                }
                if (frame.getType() == Frame.Type.CLOSE) {
                    throw new ConnectionClosedException();
                }
                if (frame.getType() == Frame.Type.TEXT) {
                    logger.debug((Object)LogMessage.format((String)"Received LiveReload text frame %s", (Object)frame));
                    break block5;
                }
                throw new IOException("Unexpected Frame Type " + frame.getType());
            }
            catch (SocketTimeoutException ex) {
                this.writeWebSocketFrame(new Frame(Frame.Type.PING));
                Frame frame = Frame.read(this.inputStream);
                if (frame.getType() == Frame.Type.PONG) break block5;
                throw new IllegalStateException("No Pong");
            }
        }
    }

    void triggerReload() throws IOException {
        if (this.webSocket) {
            logger.debug((Object)"Triggering LiveReload");
            this.writeWebSocketFrame(new Frame("{\"command\":\"reload\",\"path\":\"/\"}"));
        }
    }

    private void writeWebSocketFrame(Frame frame) throws IOException {
        frame.write(this.outputStream);
    }

    private String getWebsocketAcceptResponse() throws NoSuchAlgorithmException {
        Matcher matcher = WEBSOCKET_KEY_PATTERN.matcher(this.header);
        Assert.state((boolean)matcher.find(), (String)"No Sec-WebSocket-Key");
        String response = matcher.group(1).trim() + WEBSOCKET_GUID;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(response.getBytes(), 0, response.length());
        return Base64Utils.encodeToString((byte[])messageDigest.digest());
    }

    void close() throws IOException {
        this.running = false;
        this.socket.close();
    }
}

