/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.devtools.autoconfigure.ConditionEvaluationDeltaLoggingListener;
import org.springframework.boot.devtools.autoconfigure.DevToolsProperties;
import org.springframework.boot.devtools.autoconfigure.FileWatchingFailureHandler;
import org.springframework.boot.devtools.autoconfigure.HateoasObjenesisCacheDisabler;
import org.springframework.boot.devtools.autoconfigure.OptionalLiveReloadServer;
import org.springframework.boot.devtools.autoconfigure.TriggerFileFilter;
import org.springframework.boot.devtools.classpath.ClassPathChangedEvent;
import org.springframework.boot.devtools.classpath.ClassPathFileSystemWatcher;
import org.springframework.boot.devtools.classpath.ClassPathRestartStrategy;
import org.springframework.boot.devtools.classpath.PatternClassPathRestartStrategy;
import org.springframework.boot.devtools.filewatch.FileSystemWatcher;
import org.springframework.boot.devtools.filewatch.FileSystemWatcherFactory;
import org.springframework.boot.devtools.livereload.LiveReloadServer;
import org.springframework.boot.devtools.restart.ConditionalOnInitializedRestarter;
import org.springframework.boot.devtools.restart.RestartScope;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnInitializedRestarter
@EnableConfigurationProperties(value={DevToolsProperties.class})
public class LocalDevToolsAutoConfiguration {

    static class LiveReloadServerEventListener {
        private final OptionalLiveReloadServer liveReloadServer;

        LiveReloadServerEventListener(OptionalLiveReloadServer liveReloadServer) {
            this.liveReloadServer = liveReloadServer;
        }

        @EventListener
        public void onContextRefreshed(ContextRefreshedEvent event) {
            this.liveReloadServer.triggerReload();
        }

        @EventListener
        public void onClassPathChanged(ClassPathChangedEvent event) {
            if (!event.isRestartRequired()) {
                this.liveReloadServer.triggerReload();
            }
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.devtools.restart", name={"enabled"}, matchIfMissing=true)
    static class RestartConfiguration {
        private final DevToolsProperties properties;

        RestartConfiguration(DevToolsProperties properties) {
            this.properties = properties;
        }

        @EventListener
        public void onClassPathChanged(ClassPathChangedEvent event) {
            if (event.isRestartRequired()) {
                Restarter.getInstance().restart(new FileWatchingFailureHandler(this.fileSystemWatcherFactory()));
            }
        }

        @Bean
        @ConditionalOnMissingBean
        public ClassPathFileSystemWatcher classPathFileSystemWatcher() {
            URL[] urls = Restarter.getInstance().getInitialUrls();
            ClassPathFileSystemWatcher watcher = new ClassPathFileSystemWatcher(this.fileSystemWatcherFactory(), this.classPathRestartStrategy(), urls);
            watcher.setStopWatcherOnRestart(true);
            return watcher;
        }

        @Bean
        @ConditionalOnMissingBean
        public ClassPathRestartStrategy classPathRestartStrategy() {
            return new PatternClassPathRestartStrategy(this.properties.getRestart().getAllExclude());
        }

        @Bean
        public HateoasObjenesisCacheDisabler hateoasObjenesisCacheDisabler() {
            return new HateoasObjenesisCacheDisabler();
        }

        @Bean
        public FileSystemWatcherFactory fileSystemWatcherFactory() {
            return this::newFileSystemWatcher;
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.devtools.restart", name={"log-condition-evaluation-delta"}, matchIfMissing=true)
        public ConditionEvaluationDeltaLoggingListener conditionEvaluationDeltaLoggingListener() {
            return new ConditionEvaluationDeltaLoggingListener();
        }

        private FileSystemWatcher newFileSystemWatcher() {
            DevToolsProperties.Restart restartProperties = this.properties.getRestart();
            FileSystemWatcher watcher = new FileSystemWatcher(true, restartProperties.getPollInterval(), restartProperties.getQuietPeriod());
            String triggerFile = restartProperties.getTriggerFile();
            if (StringUtils.hasLength((String)triggerFile)) {
                watcher.setTriggerFilter(new TriggerFileFilter(triggerFile));
            }
            List<File> additionalPaths = restartProperties.getAdditionalPaths();
            for (File path : additionalPaths) {
                watcher.addSourceFolder(path.getAbsoluteFile());
            }
            return watcher;
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.devtools.livereload", name={"enabled"}, matchIfMissing=true)
    static class LiveReloadConfiguration {
        private final DevToolsProperties properties;

        LiveReloadConfiguration(DevToolsProperties properties) {
            this.properties = properties;
        }

        @Bean
        @RestartScope
        @ConditionalOnMissingBean
        public LiveReloadServer liveReloadServer() {
            return new LiveReloadServer(this.properties.getLivereload().getPort(), Restarter.getInstance().getThreadFactory());
        }

        @Bean
        public OptionalLiveReloadServer optionalLiveReloadServer(LiveReloadServer liveReloadServer) {
            return new OptionalLiveReloadServer(liveReloadServer);
        }

        @Bean
        public LiveReloadServerEventListener liveReloadServerEventListener(OptionalLiveReloadServer liveReloadServer) {
            return new LiveReloadServerEventListener(liveReloadServer);
        }
    }
}

