/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.docker.compose;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.data.redis.autoconfigure.DataRedisConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.ssl.SslBundle;

class RedisDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<DataRedisConnectionDetails> {
    private static final String[] REDIS_CONTAINER_NAMES = new String[]{"redis", "redis/redis-stack", "redis/redis-stack-server"};
    private static final int REDIS_PORT = 6379;

    RedisDockerComposeConnectionDetailsFactory() {
        super(REDIS_CONTAINER_NAMES, new String[0]);
    }

    protected DataRedisConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new RedisDockerComposeConnectionDetails(source.getRunningService());
    }

    static class RedisDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements DataRedisConnectionDetails {
        private final DataRedisConnectionDetails.Standalone standalone;
        private final @Nullable SslBundle sslBundle;

        RedisDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.standalone = DataRedisConnectionDetails.Standalone.of(service.host(), service.ports().get(6379));
            this.sslBundle = this.getSslBundle(service);
        }

        @Override
        public @Nullable SslBundle getSslBundle() {
            return this.sslBundle;
        }

        @Override
        public DataRedisConnectionDetails.Standalone getStandalone() {
            return this.standalone;
        }
    }
}

