/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cache.metrics;

import com.hazelcast.spring.cache.HazelcastCache;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.cache.HazelcastCacheMetrics;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.cache.metrics.CacheMeterBinderProvider;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@ImportRuntimeHints(value={HazelcastCacheMeterBinderProviderRuntimeHints.class})
public class HazelcastCacheMeterBinderProvider
implements CacheMeterBinderProvider<HazelcastCache> {
    @Override
    public MeterBinder getMeterBinder(HazelcastCache cache, Iterable<Tag> tags) {
        try {
            return new HazelcastCacheMetrics((Object)cache.getNativeCache(), tags);
        }
        catch (NoSuchMethodError ex) {
            return this.createHazelcast4CacheMetrics(cache, tags);
        }
    }

    private MeterBinder createHazelcast4CacheMetrics(HazelcastCache cache, Iterable<Tag> tags) {
        try {
            Method nativeCacheAccessor = ReflectionUtils.findMethod(HazelcastCache.class, (String)"getNativeCache");
            Object nativeCache = ReflectionUtils.invokeMethod((Method)nativeCacheAccessor, (Object)cache);
            return (MeterBinder)HazelcastCacheMetrics.class.getConstructor(Object.class, Iterable.class).newInstance(nativeCache, tags);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create MeterBinder for Hazelcast", ex);
        }
    }

    static class HazelcastCacheMeterBinderProviderRuntimeHints
    implements RuntimeHintsRegistrar {
        HazelcastCacheMeterBinderProviderRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            try {
                Method getNativeCacheMethod = ReflectionUtils.findMethod(HazelcastCache.class, (String)"getNativeCache");
                Assert.state((getNativeCacheMethod != null ? 1 : 0) != 0, (String)"Unable to find 'getNativeCache' method");
                Constructor constructor = HazelcastCacheMetrics.class.getConstructor(Object.class, Iterable.class);
                hints.reflection().registerMethod(getNativeCacheMethod, ExecutableMode.INVOKE).registerConstructor(constructor, ExecutableMode.INVOKE);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

