/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.batch.autoconfigure;

import org.springframework.batch.core.launch.JobOperator;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.batch.autoconfigure.BatchAutoConfiguration;
import org.springframework.boot.batch.autoconfigure.BatchProperties;
import org.springframework.boot.batch.autoconfigure.JobExecutionExitCodeGenerator;
import org.springframework.boot.batch.autoconfigure.JobLauncherApplicationRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={BatchAutoConfiguration.class})
@ConditionalOnClass(value={JobOperator.class})
@ConditionalOnBean(value={JobOperator.class})
@EnableConfigurationProperties(value={BatchProperties.class})
public final class BatchJobLauncherAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBooleanProperty(name={"spring.batch.job.enabled"}, matchIfMissing=true)
    JobLauncherApplicationRunner jobLauncherApplicationRunner(JobOperator jobOperator, BatchProperties properties) {
        JobLauncherApplicationRunner runner = new JobLauncherApplicationRunner(jobOperator);
        String jobName = properties.getJob().getName();
        if (StringUtils.hasText((String)jobName)) {
            runner.setJobName(jobName);
        }
        return runner;
    }

    @Bean
    @ConditionalOnMissingBean(value={ExitCodeGenerator.class})
    JobExecutionExitCodeGenerator jobExecutionExitCodeGenerator() {
        return new JobExecutionExitCodeGenerator();
    }
}

