/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.preinitialize;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.autoconfigure.preinitialize.BackgroundPreinitializer;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.NativeDetector;
import org.springframework.core.Ordered;
import org.springframework.core.io.support.SpringFactoriesLoader;

class BackgroundPreinitializingApplicationListener
implements ApplicationListener<SpringApplicationEvent>,
Ordered {
    public static final String IGNORE_BACKGROUNDPREINITIALIZER_PROPERTY_NAME = "spring.backgroundpreinitializer.ignore";
    private static final AtomicBoolean started = new AtomicBoolean();
    private static final CountDownLatch complete = new CountDownLatch(1);
    private final SpringFactoriesLoader factoriesLoader;
    private final boolean enabled;

    BackgroundPreinitializingApplicationListener() {
        this(SpringFactoriesLoader.forDefaultResourceLocation());
    }

    BackgroundPreinitializingApplicationListener(SpringFactoriesLoader factoriesLoader) {
        this.factoriesLoader = factoriesLoader;
        this.enabled = !NativeDetector.inNativeImage() && !Boolean.getBoolean(IGNORE_BACKGROUNDPREINITIALIZER_PROPERTY_NAME) && Runtime.getRuntime().availableProcessors() > 1;
    }

    public int getOrder() {
        return -2147483627;
    }

    public void onApplicationEvent(SpringApplicationEvent event) {
        if (!this.enabled) {
            return;
        }
        if (event instanceof ApplicationEnvironmentPreparedEvent && started.compareAndSet(false, true)) {
            this.preinitialize();
        }
        if ((event instanceof ApplicationReadyEvent || event instanceof ApplicationFailedEvent) && started.get()) {
            try {
                complete.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void preinitialize() {
        Runner runner = new Runner(this.factoriesLoader.load(BackgroundPreinitializer.class));
        try {
            Thread thread = new Thread((Runnable)runner, "background-preinit");
            thread.start();
        }
        catch (Exception ex) {
            complete.countDown();
        }
    }

    record Runner(List<BackgroundPreinitializer> preinitializers) implements Runnable
    {
        @Override
        public void run() {
            for (BackgroundPreinitializer preinitializer : this.preinitializers) {
                try {
                    preinitializer.preinitialize();
                }
                catch (Throwable throwable) {}
            }
            complete.countDown();
        }
    }
}

