/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.internal.scanner.LocationScannerCache;
import org.flywaydb.core.internal.scanner.ResourceNameCache;
import org.flywaydb.core.internal.scanner.Scanner;
import org.springframework.boot.autoconfigure.flyway.NativeImageResourceProvider;
import org.springframework.boot.autoconfigure.flyway.ResourceProviderCustomizer;

class NativeImageResourceProviderCustomizer
extends ResourceProviderCustomizer {
    NativeImageResourceProviderCustomizer() {
    }

    @Override
    public void customize(FluentConfiguration configuration) {
        if (configuration.getResourceProvider() == null) {
            Scanner<?> scanner = NativeImageResourceProviderCustomizer.createScanner(configuration);
            NativeImageResourceProvider resourceProvider = new NativeImageResourceProvider(scanner, configuration.getClassLoader(), Arrays.asList(configuration.getLocations()), configuration.getEncoding(), configuration.isFailOnMissingLocations());
            configuration.resourceProvider((ResourceProvider)resourceProvider);
        }
    }

    private static Scanner<?> createScanner(FluentConfiguration configuration) {
        try {
            return new Scanner(JavaMigration.class, Arrays.asList(configuration.getLocations()), configuration.getClassLoader(), configuration.getEncoding(), configuration.isDetectEncoding(), false, new ResourceNameCache(), new LocationScannerCache(), configuration.isFailOnMissingLocations());
        }
        catch (NoSuchMethodError ex) {
            return NativeImageResourceProviderCustomizer.createFlyway10Scanner(configuration);
        }
    }

    private static Scanner<?> createFlyway10Scanner(FluentConfiguration configuration) throws LinkageError {
        try {
            Constructor constructor = Scanner.class.getDeclaredConstructor(Class.class, Boolean.TYPE, ResourceNameCache.class, LocationScannerCache.class, Configuration.class);
            return (Scanner)constructor.newInstance(JavaMigration.class, false, new ResourceNameCache(), new LocationScannerCache(), configuration);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

