/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.artemis.autoconfigure;

import jakarta.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.commons.pool2.PooledObject;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.artemis.autoconfigure.ArtemisConnectionDetails;
import org.springframework.boot.artemis.autoconfigure.ArtemisConnectionFactoryFactory;
import org.springframework.boot.artemis.autoconfigure.ArtemisProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.jms.autoconfigure.JmsPoolConnectionFactoryFactory;
import org.springframework.boot.jms.autoconfigure.JmsProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class ArtemisConnectionFactoryConfiguration {
    ArtemisConnectionFactoryConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class, PooledObject.class})
    @ConditionalOnBooleanProperty(value={"spring.artemis.pool.enabled"})
    static class PooledConnectionFactoryConfiguration {
        PooledConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="stop")
        JmsPoolConnectionFactory jmsConnectionFactory(ListableBeanFactory beanFactory, ArtemisProperties properties, ArtemisConnectionDetails connectionDetails) {
            ActiveMQConnectionFactory connectionFactory = new ArtemisConnectionFactoryFactory(beanFactory, properties, connectionDetails).createConnectionFactory(ActiveMQConnectionFactory::new, ActiveMQConnectionFactory::new);
            return new JmsPoolConnectionFactoryFactory(properties.getPool()).createPooledConnectionFactory((ConnectionFactory)connectionFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBooleanProperty(name={"spring.artemis.pool.enabled"}, havingValue=false, matchIfMissing=true)
    static class SimpleConnectionFactoryConfiguration {
        SimpleConnectionFactoryConfiguration() {
        }

        @Bean(name={"jmsConnectionFactory"})
        @ConditionalOnBooleanProperty(name={"spring.jms.cache.enabled"}, havingValue=false)
        ActiveMQConnectionFactory jmsConnectionFactory(ArtemisProperties properties, ListableBeanFactory beanFactory, ArtemisConnectionDetails connectionDetails) {
            return SimpleConnectionFactoryConfiguration.createJmsConnectionFactory(properties, connectionDetails, beanFactory);
        }

        private static ActiveMQConnectionFactory createJmsConnectionFactory(ArtemisProperties properties, ArtemisConnectionDetails connectionDetails, ListableBeanFactory beanFactory) {
            return new ArtemisConnectionFactoryFactory(beanFactory, properties, connectionDetails).createConnectionFactory(ActiveMQConnectionFactory::new, ActiveMQConnectionFactory::new);
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={CachingConnectionFactory.class})
        @ConditionalOnBooleanProperty(name={"spring.jms.cache.enabled"}, matchIfMissing=true)
        static class CachingConnectionFactoryConfiguration {
            CachingConnectionFactoryConfiguration() {
            }

            @Bean(name={"jmsConnectionFactory"})
            CachingConnectionFactory cachingJmsConnectionFactory(JmsProperties jmsProperties, ArtemisProperties properties, ArtemisConnectionDetails connectionDetails, ListableBeanFactory beanFactory) {
                JmsProperties.Cache cacheProperties = jmsProperties.getCache();
                CachingConnectionFactory connectionFactory = new CachingConnectionFactory((ConnectionFactory)SimpleConnectionFactoryConfiguration.createJmsConnectionFactory(properties, connectionDetails, beanFactory));
                connectionFactory.setCacheConsumers(cacheProperties.isConsumers());
                connectionFactory.setCacheProducers(cacheProperties.isProducers());
                connectionFactory.setSessionCacheSize(cacheProperties.getSessionCacheSize());
                return connectionFactory;
            }
        }
    }
}

