/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.activemq.autoconfigure;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.XAConnectionFactory;
import jakarta.transaction.TransactionManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.activemq.autoconfigure.ActiveMQConnectionDetails;
import org.springframework.boot.activemq.autoconfigure.ActiveMQConnectionFactoryConfigurer;
import org.springframework.boot.activemq.autoconfigure.ActiveMQConnectionFactoryCustomizer;
import org.springframework.boot.activemq.autoconfigure.ActiveMQProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.jms.XAConnectionFactoryWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={TransactionManager.class})
@ConditionalOnBean(value={XAConnectionFactoryWrapper.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
class ActiveMQXAConnectionFactoryConfiguration {
    ActiveMQXAConnectionFactoryConfiguration() {
    }

    @Primary
    @Bean(name={"jmsConnectionFactory", "xaJmsConnectionFactory"})
    ConnectionFactory jmsConnectionFactory(ActiveMQProperties properties, ObjectProvider<ActiveMQConnectionFactoryCustomizer> factoryCustomizers, XAConnectionFactoryWrapper wrapper, ActiveMQConnectionDetails connectionDetails) throws Exception {
        ActiveMQXAConnectionFactory connectionFactory = new ActiveMQXAConnectionFactory(connectionDetails.getUser(), connectionDetails.getPassword(), connectionDetails.getBrokerUrl());
        new ActiveMQConnectionFactoryConfigurer(properties, factoryCustomizers.orderedStream().toList()).configure((ActiveMQConnectionFactory)connectionFactory);
        return wrapper.wrapConnectionFactory((XAConnectionFactory)connectionFactory);
    }

    @Bean
    @ConditionalOnBooleanProperty(name={"spring.activemq.pool.enabled"}, havingValue=false, matchIfMissing=true)
    ActiveMQConnectionFactory nonXaJmsConnectionFactory(ActiveMQProperties properties, ObjectProvider<ActiveMQConnectionFactoryCustomizer> factoryCustomizers, ActiveMQConnectionDetails connectionDetails) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectionDetails.getUser(), connectionDetails.getPassword(), connectionDetails.getBrokerUrl());
        new ActiveMQConnectionFactoryConfigurer(properties, factoryCustomizers.orderedStream().toList()).configure(connectionFactory);
        return connectionFactory;
    }
}

