/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.lang.reflect.Method;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.scope.context.JobSynchronizationManager;
import org.springframework.batch.item.adapter.HippyMethodInvoker;
import org.springframework.batch.test.MetaDataInstanceFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class JobScopeTestExecutionListener
implements TestExecutionListener {
    private static final String JOB_EXECUTION = JobScopeTestExecutionListener.class.getName() + ".JOB_EXECUTION";

    public void prepareTestInstance(TestContext testContext) throws Exception {
        JobExecution jobExecution = this.getJobExecution(testContext);
        if (jobExecution != null) {
            testContext.setAttribute(JOB_EXECUTION, (Object)jobExecution);
        }
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        if (testContext.hasAttribute(JOB_EXECUTION)) {
            JobExecution jobExecution = (JobExecution)testContext.getAttribute(JOB_EXECUTION);
            JobSynchronizationManager.register((JobExecution)jobExecution);
        }
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        if (testContext.hasAttribute(JOB_EXECUTION)) {
            JobSynchronizationManager.close();
        }
    }

    public void afterTestClass(TestContext testContext) throws Exception {
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
    }

    protected JobExecution getJobExecution(TestContext testContext) {
        Object target = testContext.getTestInstance();
        ExtractorMethodCallback method = new ExtractorMethodCallback(JobExecution.class, "getJobExecution");
        ReflectionUtils.doWithMethods(target.getClass(), (ReflectionUtils.MethodCallback)method);
        if (method.getName() != null) {
            HippyMethodInvoker invoker = new HippyMethodInvoker();
            invoker.setTargetObject(target);
            invoker.setTargetMethod(method.getName());
            try {
                invoker.prepare();
                return (JobExecution)invoker.invoke();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not create job execution from method: " + method.getName(), e);
            }
        }
        return MetaDataInstanceFactory.createJobExecution();
    }

    private final class ExtractorMethodCallback
    implements ReflectionUtils.MethodCallback {
        private String preferredName;
        private final Class<?> preferredType;
        private Method result;

        public ExtractorMethodCallback(Class<?> preferredType, String preferredName) {
            this.preferredType = preferredType;
            this.preferredName = preferredName;
        }

        public String getName() {
            return this.result == null ? null : this.result.getName();
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            Class<?> type = method.getReturnType();
            if (this.preferredType.isAssignableFrom(type) && (this.result == null || method.getName().equals(this.preferredName))) {
                this.result = method;
            }
        }
    }
}

