/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test.context;

import org.springframework.batch.test.JobLauncherTestUtils;
import org.springframework.batch.test.JobRepositoryTestUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

public class BatchTestContextCustomizer
implements ContextCustomizer {
    private static final String JOB_LAUNCHER_TEST_UTILS_BEAN_NAME = "jobLauncherTestUtils";
    private static final String JOB_REPOSITORY_TEST_UTILS_BEAN_NAME = "jobRepositoryTestUtils";

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Assert.isInstanceOf(BeanDefinitionRegistry.class, (Object)beanFactory, (String)"The bean factory must be an instance of BeanDefinitionRegistry");
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        registry.registerBeanDefinition(JOB_LAUNCHER_TEST_UTILS_BEAN_NAME, (BeanDefinition)new RootBeanDefinition(JobLauncherTestUtils.class));
        registry.registerBeanDefinition(JOB_REPOSITORY_TEST_UTILS_BEAN_NAME, (BeanDefinition)new RootBeanDefinition(JobRepositoryTestUtils.class));
    }
}

