/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database.support;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.Order;
import org.springframework.batch.infrastructure.item.database.PagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.Db2PagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.DerbyPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.H2PagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.HanaPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.HsqlPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.MariaDBPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.MySqlPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.OraclePagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.PostgresPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.SqlServerPagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.SqlitePagingQueryProvider;
import org.springframework.batch.infrastructure.item.database.support.SybasePagingQueryProvider;
import org.springframework.batch.infrastructure.support.DatabaseType;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SqlPagingQueryProviderFactoryBean
implements FactoryBean<PagingQueryProvider> {
    private @Nullable DataSource dataSource;
    private @Nullable String databaseType;
    private @Nullable String fromClause;
    private @Nullable String whereClause;
    private @Nullable String selectClause;
    private @Nullable String groupClause;
    private @Nullable Map<String, Order> sortKeys;
    private final Map<DatabaseType, AbstractSqlPagingQueryProvider> providers = new HashMap<DatabaseType, AbstractSqlPagingQueryProvider>();

    public SqlPagingQueryProviderFactoryBean() {
        this.providers.put(DatabaseType.DB2, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DB2VSE, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DB2ZOS, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DB2AS400, new Db2PagingQueryProvider());
        this.providers.put(DatabaseType.DERBY, new DerbyPagingQueryProvider());
        this.providers.put(DatabaseType.HSQL, new HsqlPagingQueryProvider());
        this.providers.put(DatabaseType.H2, new H2PagingQueryProvider());
        this.providers.put(DatabaseType.HANA, new HanaPagingQueryProvider());
        this.providers.put(DatabaseType.MYSQL, new MySqlPagingQueryProvider());
        this.providers.put(DatabaseType.MARIADB, new MariaDBPagingQueryProvider());
        this.providers.put(DatabaseType.ORACLE, new OraclePagingQueryProvider());
        this.providers.put(DatabaseType.POSTGRES, new PostgresPagingQueryProvider());
        this.providers.put(DatabaseType.SQLITE, new SqlitePagingQueryProvider());
        this.providers.put(DatabaseType.SQLSERVER, new SqlServerPagingQueryProvider());
        this.providers.put(DatabaseType.SYBASE, new SybasePagingQueryProvider());
    }

    public void setGroupClause(String groupClause) {
        this.groupClause = groupClause;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setFromClause(String fromClause) {
        this.fromClause = fromClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    public void setSortKeys(Map<String, Order> sortKeys) {
        this.sortKeys = sortKeys;
    }

    public void setSortKey(String key) {
        Assert.doesNotContain((String)key, (String)",", (String)"String setter is valid for a single ASC key only");
        this.sortKeys = Map.of(key, Order.ASCENDING);
    }

    public PagingQueryProvider getObject() throws Exception {
        DatabaseType type;
        try {
            type = this.databaseType != null ? DatabaseType.valueOf(this.databaseType.toUpperCase()) : DatabaseType.fromMetaData(this.dataSource);
        }
        catch (MetaDataAccessException e) {
            throw new IllegalArgumentException("Could not inspect meta data for database type.  You have to supply it explicitly.", e);
        }
        AbstractSqlPagingQueryProvider provider = this.providers.get((Object)type);
        Assert.state((provider != null ? 1 : 0) != 0, (String)("Should not happen: missing PagingQueryProvider for DatabaseType=" + String.valueOf((Object)type)));
        provider.setFromClause(this.fromClause);
        provider.setWhereClause(this.whereClause);
        provider.setSortKeys(this.sortKeys);
        if (StringUtils.hasText((String)this.selectClause)) {
            provider.setSelectClause(this.selectClause);
        }
        if (StringUtils.hasText((String)this.groupClause)) {
            provider.setGroupClause(this.groupClause);
        }
        provider.init(this.dataSource);
        return provider;
    }

    public Class<PagingQueryProvider> getObjectType() {
        return PagingQueryProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

