/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database.builder;

import java.math.BigInteger;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.infrastructure.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.infrastructure.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.infrastructure.item.database.JdbcBatchItemWriter;
import org.springframework.batch.infrastructure.item.database.support.ColumnMapItemPreparedStatementSetter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;

public class JdbcBatchItemWriterBuilder<T> {
    private boolean assertUpdates = true;
    private @Nullable String sql;
    private @Nullable ItemPreparedStatementSetter<T> itemPreparedStatementSetter;
    private @Nullable ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider;
    private @Nullable DataSource dataSource;
    private @Nullable NamedParameterJdbcOperations namedParameterJdbcTemplate;
    private BigInteger mapped = new BigInteger("0");

    public JdbcBatchItemWriterBuilder<T> dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> assertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> sql(String sql) {
        this.sql = sql;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> itemPreparedStatementSetter(ItemPreparedStatementSetter<T> itemPreparedStatementSetter) {
        this.itemPreparedStatementSetter = itemPreparedStatementSetter;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> itemSqlParameterSourceProvider(ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider) {
        this.itemSqlParameterSourceProvider = itemSqlParameterSourceProvider;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> namedParametersJdbcTemplate(NamedParameterJdbcOperations namedParameterJdbcOperations) {
        this.namedParameterJdbcTemplate = namedParameterJdbcOperations;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> columnMapped() {
        this.mapped = this.mapped.setBit(0);
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> beanMapped() {
        this.mapped = this.mapped.setBit(1);
        return this;
    }

    public JdbcBatchItemWriter<T> build() {
        Assert.state((this.dataSource != null || this.namedParameterJdbcTemplate != null ? 1 : 0) != 0, (String)"Either a DataSource or a NamedParameterJdbcTemplate is required");
        Assert.notNull((Object)this.sql, (String)"A SQL statement is required");
        int mappedValue = this.mapped.intValue();
        Assert.state((mappedValue != 3 ? 1 : 0) != 0, (String)"Either an item can be mapped via db column or via bean spec, can't be both");
        JdbcBatchItemWriter writer = new JdbcBatchItemWriter();
        writer.setSql(this.sql);
        writer.setAssertUpdates(this.assertUpdates);
        if (this.itemSqlParameterSourceProvider != null) {
            writer.setItemSqlParameterSourceProvider(this.itemSqlParameterSourceProvider);
        }
        if (this.itemPreparedStatementSetter != null) {
            writer.setItemPreparedStatementSetter(this.itemPreparedStatementSetter);
        }
        if (mappedValue == 1) {
            writer.setItemPreparedStatementSetter(new ColumnMapItemPreparedStatementSetter());
        } else if (mappedValue == 2) {
            writer.setItemSqlParameterSourceProvider(new BeanPropertyItemSqlParameterSourceProvider());
        }
        if (this.dataSource != null) {
            this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        }
        if (this.namedParameterJdbcTemplate != null) {
            writer.setJdbcTemplate(this.namedParameterJdbcTemplate);
        }
        writer.afterPropertiesSet();
        return writer;
    }
}

