/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.batch.infrastructure.item.KeyValueItemWriter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.Assert;

public class KafkaItemWriter<K, T>
extends KeyValueItemWriter<K, T> {
    protected KafkaTemplate<K, T> kafkaTemplate;
    protected final List<CompletableFuture<SendResult<K, T>>> completableFutures = new ArrayList<CompletableFuture<SendResult<K, T>>>();
    private long timeout = -1L;

    public KafkaItemWriter(Converter<T, K> itemKeyMapper, KafkaTemplate<K, T> kafkaTemplate) {
        super(itemKeyMapper);
        Assert.notNull(kafkaTemplate, (String)"KafkaTemplate must not be null");
        this.kafkaTemplate = kafkaTemplate;
    }

    @Override
    protected void writeKeyValue(K key, T value) {
        if (this.delete) {
            this.completableFutures.add(this.kafkaTemplate.sendDefault(key, null));
        } else {
            this.completableFutures.add(this.kafkaTemplate.sendDefault(key, value));
        }
    }

    @Override
    protected void flush() throws Exception {
        this.kafkaTemplate.flush();
        for (CompletableFuture<SendResult<K, T>> future : this.completableFutures) {
            if (this.timeout >= 0L) {
                future.get(this.timeout, TimeUnit.MILLISECONDS);
                continue;
            }
            future.get();
        }
        this.completableFutures.clear();
    }

    @Override
    protected void init() {
        Assert.state((this.kafkaTemplate.getDefaultTopic() != null ? 1 : 0) != 0, (String)"KafkaTemplate must have the default topic set.");
    }

    public void setKafkaTemplate(KafkaTemplate<K, T> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

