/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.data.builder;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.data.MongoCursorItemReader;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoCursorItemReaderBuilder<T> {
    private boolean saveState = true;
    private @Nullable String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;
    private @Nullable MongoOperations template;
    private @Nullable Class<? extends T> targetType;
    private @Nullable String collection;
    private @Nullable Query query;
    private @Nullable String jsonQuery;
    private List<Object> parameterValues = new ArrayList<Object>();
    private @Nullable String fields;
    private @Nullable Map<String, // Could not load outer class - annotation placement on inner may be incorrect
    Sort.Direction> sorts;
    private @Nullable String hint;
    private int batchSize;
    private int limit;
    private @Nullable Duration maxTime;

    public MongoCursorItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> template(MongoOperations template) {
        this.template = template;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> targetType(Class<? extends T> targetType) {
        this.targetType = targetType;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> collection(String collection) {
        this.collection = collection;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> query(Query query) {
        this.query = query;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> jsonQuery(String query) {
        this.jsonQuery = query;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> parameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> fields(String fields) {
        this.fields = fields;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> sorts(Map<String, Sort.Direction> sorts) {
        this.sorts = sorts;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> hint(String hint) {
        this.hint = hint;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> maxTime(Duration maxTime) {
        Assert.notNull((Object)maxTime, (String)"maxTime must not be null.");
        this.maxTime = maxTime;
        return this;
    }

    public MongoCursorItemReader<T> build() {
        Assert.notNull((Object)this.template, (String)"template is required.");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        Assert.notNull(this.targetType, (String)"targetType is required.");
        Assert.state((StringUtils.hasText((String)this.jsonQuery) || this.query != null ? 1 : 0) != 0, (String)"A query is required");
        Assert.notNull(this.sorts, (String)"sorts map is required.");
        MongoCursorItemReader<? extends T> reader = new MongoCursorItemReader<T>(this.template, this.targetType);
        reader.setSaveState(this.saveState);
        if (this.name != null) {
            reader.setName(this.name);
        }
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setTemplate(this.template);
        reader.setTargetType(this.targetType);
        if (this.collection != null) {
            reader.setCollection(this.collection);
        }
        if (this.query != null) {
            reader.setQuery(this.query);
        }
        if (StringUtils.hasText((String)this.jsonQuery)) {
            reader.setQuery(this.jsonQuery);
        }
        reader.setParameterValues(this.parameterValues);
        if (this.fields != null) {
            reader.setFields(this.fields);
        }
        reader.setSort(this.sorts);
        if (this.hint != null) {
            reader.setHint(this.hint);
        }
        reader.setBatchSize(this.batchSize);
        reader.setLimit(this.limit);
        if (this.maxTime != null) {
            reader.setMaxTime(this.maxTime);
        }
        return reader;
    }
}

