/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.repeat.policy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.infrastructure.repeat.CompletionPolicy;
import org.springframework.batch.infrastructure.repeat.RepeatContext;
import org.springframework.batch.infrastructure.repeat.RepeatStatus;
import org.springframework.batch.infrastructure.repeat.context.RepeatContextSupport;

public class CompositeCompletionPolicy
implements CompletionPolicy {
    CompletionPolicy[] policies = new CompletionPolicy[0];

    public void setPolicies(CompletionPolicy[] policies) {
        this.policies = Arrays.asList(policies).toArray(new CompletionPolicy[policies.length]);
    }

    @Override
    public boolean isComplete(RepeatContext context, RepeatStatus result) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i = 0; i < policies.length; ++i) {
            if (!policies[i].isComplete(contexts[i], result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplete(RepeatContext context) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i = 0; i < policies.length; ++i) {
            if (!policies[i].isComplete(contexts[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public RepeatContext start(RepeatContext context) {
        ArrayList<RepeatContext> list = new ArrayList<RepeatContext>();
        for (CompletionPolicy policy : this.policies) {
            list.add(policy.start(context));
        }
        return new CompositeBatchContext(context, list);
    }

    @Override
    public void update(RepeatContext context) {
        RepeatContext[] contexts = ((CompositeBatchContext)context).contexts;
        CompletionPolicy[] policies = ((CompositeBatchContext)context).policies;
        for (int i = 0; i < policies.length; ++i) {
            policies[i].update(contexts[i]);
        }
        ((RepeatContextSupport)context).increment();
    }

    protected class CompositeBatchContext
    extends RepeatContextSupport {
        private final RepeatContext[] contexts;
        private final CompletionPolicy[] policies;

        public CompositeBatchContext(RepeatContext context, List<RepeatContext> contexts) {
            super(context);
            this.contexts = contexts.toArray(new RepeatContext[contexts.size()]);
            this.policies = CompositeCompletionPolicy.this.policies;
        }
    }
}

