/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.amqp.builder;

import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.batch.infrastructure.item.amqp.AmqpItemReader;
import org.springframework.util.Assert;

public class AmqpItemReaderBuilder<T> {
    private @Nullable AmqpTemplate amqpTemplate;
    private @Nullable Class<? extends T> itemType;

    public AmqpItemReaderBuilder<T> amqpTemplate(AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
        return this;
    }

    public AmqpItemReaderBuilder<T> itemType(Class<? extends T> itemType) {
        this.itemType = itemType;
        return this;
    }

    public AmqpItemReader<T> build() {
        Assert.notNull((Object)this.amqpTemplate, (String)"amqpTemplate is required.");
        AmqpItemReader<? extends T> reader = new AmqpItemReader<T>(this.amqpTemplate);
        if (this.itemType != null) {
            reader.setItemType(this.itemType);
        }
        return reader;
    }
}

