/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.StringUtils;

public enum DatabaseType {
    DERBY("Apache Derby"),
    DB2("DB2"),
    DB2VSE("DB2VSE"),
    DB2ZOS("DB2ZOS"),
    DB2AS400("DB2AS400"),
    HSQL("HSQL Database Engine"),
    SQLSERVER("Microsoft SQL Server"),
    MYSQL("MySQL"),
    ORACLE("Oracle"),
    POSTGRES("PostgreSQL"),
    SYBASE("Sybase"),
    H2("H2"),
    SQLITE("SQLite"),
    HANA("HDB"),
    MARIADB("MariaDB");

    private static final Map<String, DatabaseType> nameMap;
    private final String productName;

    private DatabaseType(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public static DatabaseType fromProductName(String productName) {
        if (!nameMap.containsKey(productName)) {
            throw new IllegalArgumentException("DatabaseType not found for product name: [" + productName + "]");
        }
        return nameMap.get(productName);
    }

    public static DatabaseType fromMetaData(DataSource dataSource) throws MetaDataAccessException {
        String databaseProductVersion;
        String databaseProductName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName);
        databaseProductName = StringUtils.hasText((String)databaseProductName) && databaseProductName.startsWith("DB2") ? ((databaseProductVersion = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductVersion)).startsWith("ARI") ? "DB2VSE" : (databaseProductVersion.startsWith("DSN") ? "DB2ZOS" : (databaseProductName.contains("AS") && (databaseProductVersion.startsWith("QSQ") || databaseProductVersion.substring(databaseProductVersion.indexOf(86)).matches("V\\dR\\d[mM]\\d")) ? "DB2AS400" : JdbcUtils.commonDatabaseName((String)databaseProductName)))) : (StringUtils.hasText((String)databaseProductName) && databaseProductName.startsWith("EnterpriseDB") ? "PostgreSQL" : JdbcUtils.commonDatabaseName((String)databaseProductName));
        return DatabaseType.fromProductName(databaseProductName);
    }

    static {
        nameMap = new HashMap<String, DatabaseType>();
        for (DatabaseType type : DatabaseType.values()) {
            nameMap.put(type.getProductName(), type);
        }
    }
}

