/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import org.springframework.batch.item.data.GemfireItemWriter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.util.Assert;

public class GemfireItemWriterBuilder<K, V> {
    private GemfireTemplate template;
    private Converter<V, K> itemKeyMapper;
    private boolean delete;

    public GemfireItemWriterBuilder<K, V> template(GemfireTemplate template) {
        this.template = template;
        return this;
    }

    public GemfireItemWriterBuilder<K, V> itemKeyMapper(Converter<V, K> itemKeyMapper) {
        this.itemKeyMapper = itemKeyMapper;
        return this;
    }

    public GemfireItemWriterBuilder<K, V> delete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public GemfireItemWriter<K, V> build() {
        Assert.notNull((Object)this.template, (String)"template is required.");
        Assert.notNull(this.itemKeyMapper, (String)"itemKeyMapper is required.");
        GemfireItemWriter<K, V> writer = new GemfireItemWriter<K, V>();
        writer.setTemplate(this.template);
        writer.setItemKeyMapper(this.itemKeyMapper);
        writer.setDelete(this.delete);
        return writer;
    }
}

