/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.kafka;

import org.springframework.batch.item.KeyValueItemWriter;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.Assert;

public class KafkaItemWriter<K, T>
extends KeyValueItemWriter<K, T> {
    protected KafkaTemplate<K, T> kafkaTemplate;

    @Override
    protected void writeKeyValue(K key, T value) {
        if (this.delete) {
            this.kafkaTemplate.sendDefault(key, null);
        } else {
            this.kafkaTemplate.sendDefault(key, value);
        }
    }

    @Override
    protected void init() {
        Assert.notNull(this.kafkaTemplate, (String)"KafkaTemplate must not be null.");
        Assert.notNull((Object)this.kafkaTemplate.getDefaultTopic(), (String)"KafkaTemplate must have the default topic set.");
    }

    public void setKafkaTemplate(KafkaTemplate<K, T> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

