/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.mail.builder;

import org.springframework.batch.item.mail.DefaultMailErrorHandler;
import org.springframework.batch.item.mail.MailErrorHandler;
import org.springframework.batch.item.mail.SimpleMailMessageItemWriter;
import org.springframework.mail.MailSender;
import org.springframework.util.Assert;

public class SimpleMailMessageItemWriterBuilder {
    private MailSender mailSender;
    private MailErrorHandler mailErrorHandler = new DefaultMailErrorHandler();

    public SimpleMailMessageItemWriterBuilder mailSender(MailSender mailSender) {
        this.mailSender = mailSender;
        return this;
    }

    public SimpleMailMessageItemWriterBuilder mailErrorHandler(MailErrorHandler mailErrorHandler) {
        this.mailErrorHandler = mailErrorHandler;
        return this;
    }

    public SimpleMailMessageItemWriter build() {
        Assert.notNull((Object)this.mailSender, (String)"A mailSender is required");
        SimpleMailMessageItemWriter writer = new SimpleMailMessageItemWriter();
        writer.setMailSender(this.mailSender);
        if (this.mailErrorHandler != null) {
            writer.setMailErrorHandler(this.mailErrorHandler);
        }
        return writer;
    }
}

