/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.orm;

import javax.persistence.Query;
import org.springframework.batch.item.database.orm.AbstractJpaQueryProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaNativeQueryProvider<E>
extends AbstractJpaQueryProvider {
    private Class<E> entityClass;
    private String sqlQuery;

    @Override
    public Query createQuery() {
        return this.getEntityManager().createNativeQuery(this.sqlQuery, this.entityClass);
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public void setEntityClass(Class<E> entityClazz) {
        this.entityClass = entityClazz;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((boolean)StringUtils.hasText((String)this.sqlQuery), (String)"Native SQL query cannot be empty");
        Assert.notNull(this.entityClass, (String)"Entity class cannot be NULL");
    }
}

