/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public final class PropertiesConverter {
    private static final PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private PropertiesConverter() {
    }

    public static Properties stringToProperties(String stringToParse) {
        if (stringToParse == null) {
            return new Properties();
        }
        if (!PropertiesConverter.contains(stringToParse, "\n")) {
            return StringUtils.splitArrayElementsIntoProperties((String[])StringUtils.commaDelimitedListToStringArray((String)stringToParse), (String)"=");
        }
        StringReader stringReader = new StringReader(stringToParse);
        Properties properties = new Properties();
        try {
            propertiesPersister.load(properties, (Reader)stringReader);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error while trying to parse String to java.util.Properties, given String: " + properties);
        }
        return properties;
    }

    public static String propertiesToString(Properties propertiesToParse) {
        if (propertiesToParse == null || propertiesToParse.size() == 0) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            propertiesPersister.store(propertiesToParse, (Writer)stringWriter, null);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error while trying to convert properties to string");
        }
        String value = stringWriter.toString();
        if (value.length() < 160) {
            List<String> list = Arrays.asList(StringUtils.delimitedListToStringArray((String)value, (String)LINE_SEPARATOR, (String)LINE_SEPARATOR));
            String shortValue = StringUtils.collectionToCommaDelimitedString(list.subList(1, list.size()));
            int count = StringUtils.countOccurrencesOf((String)shortValue, (String)",");
            if (count == list.size() - 2) {
                value = shortValue;
            }
            if (value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
        }
        return value;
    }

    private static boolean contains(String str, String searchStr) {
        return str.indexOf(searchStr) != -1;
    }
}

