/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.exception;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.classify.ClassifierSupport;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogOrRethrowExceptionHandler
implements ExceptionHandler {
    protected final Log logger = LogFactory.getLog(LogOrRethrowExceptionHandler.class);
    private Classifier<Throwable, Level> exceptionClassifier = new ClassifierSupport<Throwable, Level>(Level.RETHROW);

    public void setExceptionClassifier(Classifier<Throwable, Level> exceptionClassifier) {
        this.exceptionClassifier = exceptionClassifier;
    }

    @Override
    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        Level key = this.exceptionClassifier.classify(throwable);
        if (Level.ERROR.equals((Object)key)) {
            this.logger.error((Object)"Exception encountered in batch repeat.", throwable);
        } else if (Level.WARN.equals((Object)key)) {
            this.logger.warn((Object)"Exception encountered in batch repeat.", throwable);
        } else if (Level.DEBUG.equals((Object)key) && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exception encountered in batch repeat.", throwable);
        } else if (Level.RETHROW.equals((Object)key)) {
            throw throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        RETHROW,
        DEBUG,
        WARN,
        ERROR;

    }
}

