/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.metrics.memory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.springframework.analytics.metrics.AggregateCounter;
import org.springframework.analytics.metrics.AggregateCounterRepository;
import org.springframework.analytics.metrics.AggregateCounterResolution;
import org.springframework.analytics.metrics.memory.InMemoryAggregateCounter;

public class InMemoryAggregateCounterRepository
implements AggregateCounterRepository {
    private Map<String, InMemoryAggregateCounter> aggregates = new ConcurrentHashMap<String, InMemoryAggregateCounter>();
    private Map<String, AggregateCounter> counters = new ConcurrentHashMap<String, AggregateCounter>();

    public long increment(String name) {
        return this.increment(name, 1L, DateTime.now());
    }

    public long decrement(String name) {
        throw new UnsupportedOperationException("Can't decrement an AggregateCounter");
    }

    @Override
    public void reset(String name) {
        this.aggregates.remove(name);
        this.counters.remove(name);
    }

    @Override
    public long increment(String name, long amount, DateTime dateTime) {
        InMemoryAggregateCounter counter = this.getOrCreate(name);
        return counter.increment(amount, dateTime);
    }

    @Override
    public AggregateCounter getCounts(String name, int nCounts, AggregateCounterResolution resolution) {
        return this.getOrCreate(name).getCounts(nCounts, new DateTime(), resolution);
    }

    @Override
    public AggregateCounter getCounts(String name, Interval interval, AggregateCounterResolution resolution) {
        return this.getOrCreate(name).getCounts(interval, resolution);
    }

    @Override
    public AggregateCounter findOne(String name) {
        return this.counters.get(name);
    }

    @Override
    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.aggregates.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    public AggregateCounter getCounts(String name, int nCounts, DateTime end, AggregateCounterResolution resolution) {
        return this.getOrCreate(name).getCounts(nCounts, end, resolution);
    }

    private synchronized InMemoryAggregateCounter getOrCreate(String name) {
        InMemoryAggregateCounter c = this.aggregates.get(name);
        if (c == null) {
            c = new InMemoryAggregateCounter(name);
            this.aggregates.put(name, c);
        }
        return c;
    }

    public AggregateCounter save(AggregateCounter counter) {
        this.aggregates.remove(counter.getName());
        this.counters.put(counter.getName(), counter);
        this.increment(counter.getName(), counter.getTotal(), DateTime.now());
        return counter;
    }
}

