/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.util.HashMap;
import java.util.Map;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MicrometerHolder;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public abstract class ObservableListenerContainer
extends RabbitAccessor
implements MessageListenerContainer,
ApplicationContextAware,
BeanNameAware,
DisposableBean {
    private static final boolean MICROMETER_PRESENT = ClassUtils.isPresent((String)"io.micrometer.core.instrument.MeterRegistry", (ClassLoader)AbstractMessageListenerContainer.class.getClassLoader());
    private ApplicationContext applicationContext;
    private final Map<String, String> micrometerTags = new HashMap<String, String>();
    private MicrometerHolder micrometerHolder;
    private boolean micrometerEnabled = true;
    private boolean observationEnabled = false;
    private String beanName = "not.a.Spring.bean";
    private String listenerId;

    @Nullable
    protected final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected MicrometerHolder getMicrometerHolder() {
        return this.micrometerHolder;
    }

    public void setMicrometerTags(Map<String, String> tags) {
        if (tags != null) {
            this.micrometerTags.putAll(tags);
        }
    }

    public void setMicrometerEnabled(boolean micrometerEnabled) {
        this.micrometerEnabled = micrometerEnabled;
    }

    public void setObservationEnabled(boolean observationEnabled) {
        this.observationEnabled = observationEnabled;
    }

    protected void checkMicrometer() {
        try {
            if (this.micrometerHolder == null && MICROMETER_PRESENT && this.micrometerEnabled && !this.observationEnabled && this.applicationContext != null) {
                this.micrometerHolder = new MicrometerHolder(this.applicationContext, this.getListenerId(), this.micrometerTags);
            }
        }
        catch (IllegalStateException e) {
            this.logger.debug((Object)"Could not enable micrometer timers", (Throwable)e);
        }
    }

    protected void checkObservation() {
        if (this.observationEnabled) {
            this.obtainObservationRegistry(this.applicationContext);
        }
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Nullable
    protected final String getBeanName() {
        return this.beanName;
    }

    public String getListenerId() {
        return this.listenerId != null ? this.listenerId : this.beanName;
    }

    @Override
    public void setListenerId(String listenerId) {
        this.listenerId = listenerId;
    }

    public void destroy() {
        if (this.micrometerHolder != null) {
            this.micrometerHolder.destroy();
        }
    }
}

