/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.rabbit.config.AbstractRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.utils.JavaUtils;

public class SimpleRabbitListenerContainerFactory
extends AbstractRabbitListenerContainerFactory<SimpleMessageListenerContainer> {
    private Integer batchSize;
    private Integer concurrentConsumers;
    private Integer maxConcurrentConsumers;
    private Long startConsumerMinInterval;
    private Long stopConsumerMinInterval;
    private Integer consecutiveActiveTrigger;
    private Integer consecutiveIdleTrigger;
    private Long receiveTimeout;
    private Boolean consumerBatchEnabled;

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setConcurrentConsumers(Integer concurrency) {
        this.concurrentConsumers = concurrency;
    }

    public void setMaxConcurrentConsumers(Integer maxConcurrency) {
        this.maxConcurrentConsumers = maxConcurrency;
    }

    public void setStartConsumerMinInterval(Long minStartInterval) {
        this.startConsumerMinInterval = minStartInterval;
    }

    public void setStopConsumerMinInterval(Long minStopInterval) {
        this.stopConsumerMinInterval = minStopInterval;
    }

    public void setConsecutiveActiveTrigger(Integer minConsecutiveActive) {
        this.consecutiveActiveTrigger = minConsecutiveActive;
    }

    public void setConsecutiveIdleTrigger(Integer minConsecutiveIdle) {
        this.consecutiveIdleTrigger = minConsecutiveIdle;
    }

    public void setReceiveTimeout(Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setConsumerBatchEnabled(boolean consumerBatchEnabled) {
        this.consumerBatchEnabled = consumerBatchEnabled;
    }

    @Override
    protected SimpleMessageListenerContainer createContainerInstance() {
        return new SimpleMessageListenerContainer();
    }

    @Override
    protected void initializeContainer(SimpleMessageListenerContainer instance, RabbitListenerEndpoint endpoint) {
        super.initializeContainer(instance, endpoint);
        JavaUtils javaUtils = JavaUtils.INSTANCE.acceptIfNotNull((Object)this.batchSize, instance::setBatchSize);
        String concurrency = null;
        if (endpoint != null) {
            concurrency = endpoint.getConcurrency();
            javaUtils.acceptIfNotNull((Object)concurrency, instance::setConcurrency);
        }
        javaUtils.acceptIfCondition(concurrency == null && this.concurrentConsumers != null, (Object)this.concurrentConsumers, instance::setConcurrentConsumers).acceptIfCondition(!(concurrency != null && concurrency.contains("-") || this.maxConcurrentConsumers == null), (Object)this.maxConcurrentConsumers, instance::setMaxConcurrentConsumers).acceptIfNotNull((Object)this.startConsumerMinInterval, instance::setStartConsumerMinInterval).acceptIfNotNull((Object)this.stopConsumerMinInterval, instance::setStopConsumerMinInterval).acceptIfNotNull((Object)this.consecutiveActiveTrigger, instance::setConsecutiveActiveTrigger).acceptIfNotNull((Object)this.consecutiveIdleTrigger, instance::setConsecutiveIdleTrigger).acceptIfNotNull((Object)this.receiveTimeout, instance::setReceiveTimeout);
        if (Boolean.TRUE.equals(this.consumerBatchEnabled)) {
            instance.setConsumerBatchEnabled(true);
            instance.setDeBatchingEnabled(true);
        }
    }
}

