/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.impl.recovery.AutorecoveringChannel;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;

public final class ClosingRecoveryListener
implements RecoveryListener {
    private static final Log logger = LogFactory.getLog(ClosingRecoveryListener.class);
    private static final RecoveryListener INSTANCE = new ClosingRecoveryListener();
    private static final ConcurrentMap<AutorecoveringChannel, Boolean> hasListener = new ConcurrentHashMap<AutorecoveringChannel, Boolean>();

    private ClosingRecoveryListener() {
    }

    public void handleRecovery(Recoverable recoverable) {
        this.handleRecoveryStarted(recoverable);
    }

    public void handleRecoveryStarted(Recoverable recoverable) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing an autorecovered channel: " + recoverable));
        }
        try {
            ((Channel)recoverable).close();
        }
        catch (IOException | TimeoutException e) {
            logger.error((Object)"Error closing an autorecovered channel", (Throwable)e);
        }
        finally {
            hasListener.remove(recoverable);
        }
    }

    public static void addRecoveryListenerIfNecessary(Channel channel) {
        AutorecoveringChannel autorecoveringChannel = null;
        if (channel instanceof ChannelProxy) {
            if (((ChannelProxy)channel).getTargetChannel() instanceof AutorecoveringChannel) {
                autorecoveringChannel = (AutorecoveringChannel)((ChannelProxy)channel).getTargetChannel();
            }
        } else if (channel instanceof AutorecoveringChannel) {
            autorecoveringChannel = (AutorecoveringChannel)channel;
        }
        if (autorecoveringChannel != null && hasListener.putIfAbsent(autorecoveringChannel, Boolean.TRUE) == null) {
            autorecoveringChannel.addRecoveryListener(INSTANCE);
        }
    }

    public static void removeChannel(AutorecoveringChannel channel) {
        hasListener.remove(channel);
    }
}

