/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.springframework.amqp.event.AmqpEvent;
import org.springframework.lang.Nullable;

public class ListenerContainerIdleEvent
extends AmqpEvent {
    private final long idleTime;
    @Nullable
    private final String listenerId;
    private final List<String> queueNames;

    public ListenerContainerIdleEvent(Object source, long idleTime, @Nullable String id, String ... queueNames) {
        super(source);
        this.idleTime = idleTime;
        this.listenerId = id;
        this.queueNames = Arrays.asList(queueNames);
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public String[] getQueueNames() {
        return this.queueNames.toArray(new String[this.queueNames.size()]);
    }

    @Nullable
    public String getListenerId() {
        return this.listenerId;
    }

    public String toString() {
        return "ListenerContainerIdleEvent [idleTime=" + Duration.ofMillis(this.idleTime) + ", listenerId=" + this.listenerId + ", container=" + this.getSource() + "]";
    }
}

