/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener.adapter;

import com.rabbitmq.client.Channel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.rabbit.batch.BatchingStrategy;
import org.springframework.amqp.rabbit.batch.SimpleBatchingStrategy;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareBatchMessageListener;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageBuilder;

public class BatchMessagingMessageListenerAdapter
extends MessagingMessageListenerAdapter
implements ChannelAwareBatchMessageListener {
    private final MessagingMessageListenerAdapter.MessagingMessageConverterAdapter converterAdapter = (MessagingMessageListenerAdapter.MessagingMessageConverterAdapter)this.getMessagingMessageConverter();
    private final BatchingStrategy batchingStrategy;

    public BatchMessagingMessageListenerAdapter(Object bean, Method method, boolean returnExceptions, RabbitListenerErrorHandler errorHandler, @Nullable BatchingStrategy batchingStrategy) {
        super(bean, method, returnExceptions, errorHandler, true);
        this.batchingStrategy = batchingStrategy == null ? new SimpleBatchingStrategy(0, 0, 0L) : batchingStrategy;
    }

    @Override
    public void onMessageBatch(List<org.springframework.amqp.core.Message> messages, Channel channel) {
        GenericMessage converted;
        if (this.converterAdapter.isAmqpMessageList()) {
            converted = new GenericMessage(messages);
        } else {
            ArrayList messagingMessages = new ArrayList();
            for (org.springframework.amqp.core.Message message : messages) {
                messagingMessages.add(this.toMessagingMessage(message));
            }
            if (this.converterAdapter.isMessageList()) {
                converted = new GenericMessage(messagingMessages);
            } else {
                ArrayList<Object> payloads = new ArrayList<Object>();
                for (Message message : messagingMessages) {
                    payloads.add(message.getPayload());
                }
                converted = new GenericMessage(payloads);
            }
        }
        try {
            this.invokeHandlerAndProcessResult(null, channel, (Message<?>)converted);
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    protected Message<?> toMessagingMessage(org.springframework.amqp.core.Message amqpMessage) {
        if (this.batchingStrategy.canDebatch(amqpMessage.getMessageProperties())) {
            if (this.converterAdapter.isMessageList()) {
                ArrayList messages = new ArrayList();
                this.batchingStrategy.deBatch(amqpMessage, fragment -> messages.add(super.toMessagingMessage((org.springframework.amqp.core.Message)fragment)));
                return new GenericMessage(messages);
            }
            ArrayList list = new ArrayList();
            this.batchingStrategy.deBatch(amqpMessage, fragment -> list.add(this.converterAdapter.extractPayload((org.springframework.amqp.core.Message)fragment)));
            return MessageBuilder.withPayload(list).copyHeaders((Map)this.converterAdapter.getHeaderMapper().toHeaders((Object)amqpMessage.getMessageProperties())).build();
        }
        return super.toMessagingMessage(amqpMessage);
    }
}

