/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.annotation;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.annotation.RabbitListenerAnnotationBeanPostProcessor;
import org.springframework.util.StringUtils;

public class MultiRabbitListenerAnnotationBeanPostProcessor
extends RabbitListenerAnnotationBeanPostProcessor {
    @Override
    protected Collection<Declarable> processAmqpListener(RabbitListener rabbitListener, Method method, Object bean, String beanName) {
        String rabbitAdmin = this.resolveMultiRabbitAdminName(rabbitListener);
        RabbitListener rabbitListenerRef = this.proxyIfAdminNotPresent(rabbitListener, rabbitAdmin);
        Collection<Declarable> declarables = super.processAmqpListener(rabbitListenerRef, method, bean, beanName);
        for (Declarable declarable : declarables) {
            if (!declarable.getDeclaringAdmins().isEmpty()) continue;
            declarable.setAdminsThatShouldDeclare(new Object[]{rabbitAdmin});
        }
        return declarables;
    }

    private RabbitListener proxyIfAdminNotPresent(RabbitListener rabbitListener, String rabbitAdmin) {
        if (StringUtils.hasText((String)rabbitListener.admin())) {
            return rabbitListener;
        }
        return (RabbitListener)Proxy.newProxyInstance(RabbitListener.class.getClassLoader(), new Class[]{RabbitListener.class}, (InvocationHandler)new RabbitListenerAdminReplacementInvocationHandler(rabbitListener, rabbitAdmin));
    }

    protected String resolveMultiRabbitAdminName(RabbitListener rabbitListener) {
        String admin = super.resolveExpressionAsString(rabbitListener.admin(), "admin");
        if (!StringUtils.hasText((String)admin) && StringUtils.hasText((String)rabbitListener.containerFactory())) {
            admin = rabbitListener.containerFactory() + "-admin";
        }
        if (!StringUtils.hasText((String)admin)) {
            admin = "amqpAdmin";
        }
        return admin;
    }

    private static final class RabbitListenerAdminReplacementInvocationHandler
    implements InvocationHandler {
        private final RabbitListener target;
        private final String admin;

        private RabbitListenerAdminReplacementInvocationHandler(RabbitListener target, String admin) {
            this.target = target;
            this.admin = admin;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
            if (method.getName().equals("admin")) {
                return this.admin;
            }
            return method.invoke((Object)this.target, args);
        }
    }
}

