/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.util.Assert;

public class Message
implements Serializable {
    private static final long serialVersionUID = -7177590352110605597L;
    private static final String DEFAULT_ENCODING;
    private static final int DEFAULT_MAX_BODY_LENGTH = 50;
    private static String bodyEncoding;
    private static int maxBodyLength;
    private final MessageProperties messageProperties;
    private final byte[] body;

    public Message(byte[] body) {
        this(body, new MessageProperties());
    }

    public Message(byte[] body, MessageProperties messageProperties) {
        Assert.notNull((Object)body, (String)"'body' cannot be null");
        Assert.notNull((Object)messageProperties, (String)"'messageProperties' cannot be null");
        this.body = body;
        this.messageProperties = messageProperties;
    }

    public static void setDefaultEncoding(String encoding) {
        Assert.notNull((Object)encoding, (String)"'encoding' cannot be null");
        bodyEncoding = encoding;
    }

    public static void setMaxBodyLength(int length) {
        maxBodyLength = length;
    }

    public byte[] getBody() {
        return this.body;
    }

    public MessageProperties getMessageProperties() {
        return this.messageProperties;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("(");
        buffer.append("Body:'").append(this.getBodyContentAsString()).append("'");
        buffer.append(" ").append(this.messageProperties.toString());
        buffer.append(")");
        return buffer.toString();
    }

    private String getBodyContentAsString() {
        try {
            String contentType = this.messageProperties.getContentType();
            if ("application/x-java-serialized-object".equals(contentType)) {
                return "[serialized object]";
            }
            String encoding = this.encoding();
            if (this.body.length <= maxBodyLength && ("text/plain".equals(contentType) || "application/json".equals(contentType) || "text/x-json".equals(contentType) || "application/xml".equals(contentType))) {
                return new String(this.body, encoding);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.body.toString() + "(byte[" + this.body.length + "])";
    }

    private String encoding() {
        String encoding = this.messageProperties.getContentEncoding();
        if (encoding == null) {
            encoding = bodyEncoding;
        }
        return encoding;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + (this.messageProperties == null ? 0 : this.messageProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        return !(this.messageProperties == null ? other.messageProperties != null : !this.messageProperties.equals(other.messageProperties));
    }

    static {
        bodyEncoding = DEFAULT_ENCODING = Charset.defaultCharset().name();
        maxBodyLength = 50;
    }
}

