/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractJavaTypeMapper;
import org.springframework.amqp.support.converter.Jackson2JavaTypeMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultJackson2JavaTypeMapper
extends AbstractJavaTypeMapper
implements Jackson2JavaTypeMapper {
    private static final List<String> TRUSTED_PACKAGES = Arrays.asList("java.util", "java.lang");
    private final Set<String> trustedPackages = new LinkedHashSet<String>(TRUSTED_PACKAGES);
    private volatile Jackson2JavaTypeMapper.TypePrecedence typePrecedence = Jackson2JavaTypeMapper.TypePrecedence.INFERRED;

    @Override
    public Jackson2JavaTypeMapper.TypePrecedence getTypePrecedence() {
        return this.typePrecedence;
    }

    public void setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence typePrecedence) {
        Assert.notNull((Object)((Object)typePrecedence), (String)"'typePrecedence' cannot be null");
        this.typePrecedence = typePrecedence;
    }

    public void setTrustedPackages(String ... trustedPackages) {
        if (trustedPackages != null) {
            for (String trusted : trustedPackages) {
                if ("*".equals(trusted)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(trusted);
            }
        }
    }

    @Override
    public void addTrustedPackages(String ... packages) {
        this.setTrustedPackages(packages);
    }

    @Override
    public JavaType toJavaType(MessageProperties properties) {
        JavaType inferredType = this.getInferredType(properties);
        if (inferredType != null && this.canConvert(inferredType)) {
            return inferredType;
        }
        String typeIdHeader = this.retrieveHeaderAsString(properties, this.getClassIdFieldName());
        if (typeIdHeader != null) {
            return this.fromTypeHeader(properties, typeIdHeader);
        }
        if (this.hasInferredTypeHeader(properties)) {
            return this.fromInferredTypeHeader(properties);
        }
        return TypeFactory.defaultInstance().constructType(Object.class);
    }

    private boolean canConvert(JavaType inferredType) {
        if (inferredType.isAbstract() && !inferredType.isContainerType()) {
            return false;
        }
        if (inferredType.isContainerType() && inferredType.getContentType().isAbstract()) {
            return false;
        }
        return inferredType.getKeyType() == null || !inferredType.getKeyType().isAbstract();
    }

    private JavaType fromTypeHeader(MessageProperties properties, String typeIdHeader) {
        JavaType classType = this.getClassIdType(typeIdHeader);
        if (!classType.isContainerType() || classType.isArrayType()) {
            return classType;
        }
        JavaType contentClassType = this.getClassIdType(this.retrieveHeader(properties, this.getContentClassIdFieldName()));
        if (classType.getKeyType() == null) {
            return TypeFactory.defaultInstance().constructCollectionLikeType(classType.getRawClass(), contentClassType);
        }
        JavaType keyClassType = this.getClassIdType(this.retrieveHeader(properties, this.getKeyClassIdFieldName()));
        return TypeFactory.defaultInstance().constructMapLikeType(classType.getRawClass(), keyClassType, contentClassType);
    }

    @Override
    @Nullable
    public JavaType getInferredType(MessageProperties properties) {
        if (this.typePrecedence.equals((Object)Jackson2JavaTypeMapper.TypePrecedence.INFERRED) && this.hasInferredTypeHeader(properties)) {
            return this.fromInferredTypeHeader(properties);
        }
        return null;
    }

    private JavaType getClassIdType(String classId) {
        if (this.getIdClassMapping().containsKey(classId)) {
            return TypeFactory.defaultInstance().constructType((Type)this.getIdClassMapping().get(classId));
        }
        try {
            if (!this.isTrustedPackage(classId)) {
                throw new IllegalArgumentException("The class '" + classId + "' is not in the trusted packages: " + this.trustedPackages + ". If you believe this class is safe to deserialize, please provide its name. If the serialization is only done by a trusted source, you can also enable trust all (*).");
            }
            return TypeFactory.defaultInstance().constructType((Type)ClassUtils.forName((String)classId, (ClassLoader)this.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name. Class not found [" + classId + "]", e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name. Linkage error [" + classId + "]", e);
        }
    }

    private boolean isTrustedPackage(String requestedType) {
        if (!this.trustedPackages.isEmpty()) {
            String packageName = ClassUtils.getPackageName((String)requestedType).replaceFirst("\\[L", "");
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void fromJavaType(JavaType javaType, MessageProperties properties) {
        this.addHeader(properties, this.getClassIdFieldName(), javaType.getRawClass());
        if (javaType.isContainerType() && !javaType.isArrayType()) {
            this.addHeader(properties, this.getContentClassIdFieldName(), javaType.getContentType().getRawClass());
        }
        if (javaType.getKeyType() != null) {
            this.addHeader(properties, this.getKeyClassIdFieldName(), javaType.getKeyType().getRawClass());
        }
    }

    @Override
    public void fromClass(Class<?> clazz, MessageProperties properties) {
        this.fromJavaType(TypeFactory.defaultInstance().constructType(clazz), properties);
    }

    @Override
    public Class<?> toClass(MessageProperties properties) {
        return this.toJavaType(properties).getRawClass();
    }
}

