/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.openai;

import org.springframework.ai.autoconfigure.openai.OpenAiParentProperties;
import org.springframework.ai.openai.OpenAiAudioTranscriptionOptions;
import org.springframework.ai.openai.api.OpenAiAudioApi;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="spring.ai.openai.audio.transcription")
public class OpenAiAudioTranscriptionProperties
extends OpenAiParentProperties {
    public static final String CONFIG_PREFIX = "spring.ai.openai.audio.transcription";
    public static final String DEFAULT_TRANSCRIPTION_MODEL = OpenAiAudioApi.WhisperModel.WHISPER_1.getValue();
    private static final Double DEFAULT_TEMPERATURE = 0.7;
    private static final OpenAiAudioApi.TranscriptResponseFormat DEFAULT_RESPONSE_FORMAT = OpenAiAudioApi.TranscriptResponseFormat.TEXT;
    private boolean enabled = true;
    @NestedConfigurationProperty
    private OpenAiAudioTranscriptionOptions options = OpenAiAudioTranscriptionOptions.builder().model(DEFAULT_TRANSCRIPTION_MODEL).temperature(Float.valueOf(DEFAULT_TEMPERATURE.floatValue())).responseFormat(DEFAULT_RESPONSE_FORMAT).build();

    public OpenAiAudioTranscriptionOptions getOptions() {
        return this.options;
    }

    public void setOptions(OpenAiAudioTranscriptionOptions options) {
        this.options = options;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

