/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.oci.genai;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimpleAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SimplePrivateKeySupplier;
import com.oracle.bmc.auth.okeworkloadidentity.OkeWorkloadIdentityAuthenticationDetailsProvider;
import com.oracle.bmc.generativeaiinference.GenerativeAiInference;
import com.oracle.bmc.generativeaiinference.GenerativeAiInferenceClient;
import com.oracle.bmc.retrier.RetryConfiguration;
import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.util.function.Supplier;
import org.springframework.ai.autoconfigure.oci.genai.OCICohereChatModelProperties;
import org.springframework.ai.autoconfigure.oci.genai.OCIConnectionProperties;
import org.springframework.ai.autoconfigure.oci.genai.OCIEmbeddingModelProperties;
import org.springframework.ai.chat.observation.ChatModelObservationConvention;
import org.springframework.ai.oci.OCIEmbeddingModel;
import org.springframework.ai.oci.cohere.OCICohereChatModel;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfiguration
@ConditionalOnClass(value={GenerativeAiInferenceClient.class, OCIEmbeddingModel.class})
@EnableConfigurationProperties(value={OCIConnectionProperties.class, OCIEmbeddingModelProperties.class, OCICohereChatModelProperties.class})
public class OCIGenAiAutoConfiguration {
    private static BasicAuthenticationDetailsProvider authenticationProvider(OCIConnectionProperties properties) throws IOException {
        return switch (properties.getAuthenticationType()) {
            default -> throw new IncompatibleClassChangeError();
            case OCIConnectionProperties.AuthenticationType.FILE -> new ConfigFileAuthenticationDetailsProvider(properties.getFile(), properties.getProfile());
            case OCIConnectionProperties.AuthenticationType.INSTANCE_PRINCIPAL -> InstancePrincipalsAuthenticationDetailsProvider.builder().build();
            case OCIConnectionProperties.AuthenticationType.WORKLOAD_IDENTITY -> OkeWorkloadIdentityAuthenticationDetailsProvider.builder().build();
            case OCIConnectionProperties.AuthenticationType.SIMPLE -> SimpleAuthenticationDetailsProvider.builder().userId(properties.getUserId()).tenantId(properties.getTenantId()).fingerprint(properties.getFingerprint()).privateKeySupplier((Supplier)new SimplePrivateKeySupplier(properties.getPrivateKey())).passPhrase(properties.getPassPhrase()).region(Region.valueOf((String)properties.getRegion())).build();
        };
    }

    @ConditionalOnMissingBean
    @Bean
    public GenerativeAiInferenceClient generativeAiInferenceClient(OCIConnectionProperties properties) throws IOException {
        ClientConfiguration clientConfiguration = ClientConfiguration.builder().retryConfiguration(RetryConfiguration.SDK_DEFAULT_RETRY_CONFIGURATION).build();
        GenerativeAiInferenceClient.Builder builder = (GenerativeAiInferenceClient.Builder)GenerativeAiInferenceClient.builder().configuration(clientConfiguration);
        if (StringUtils.hasText((String)properties.getRegion())) {
            builder.region(Region.valueOf((String)properties.getRegion()));
        }
        if (StringUtils.hasText((String)properties.getEndpoint())) {
            builder.endpoint(properties.getEndpoint());
        }
        return builder.build((AbstractAuthenticationDetailsProvider)OCIGenAiAutoConfiguration.authenticationProvider(properties));
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.oci.genai.embedding", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OCIEmbeddingModel ociEmbeddingModel(GenerativeAiInferenceClient generativeAiClient, OCIEmbeddingModelProperties properties) {
        return new OCIEmbeddingModel((GenerativeAiInference)generativeAiClient, properties.getEmbeddingOptions());
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.ai.oci.genai.cohere.chat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public OCICohereChatModel ociChatModel(GenerativeAiInferenceClient generativeAiClient, OCICohereChatModelProperties properties, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<ChatModelObservationConvention> observationConvention) {
        OCICohereChatModel chatModel = new OCICohereChatModel((GenerativeAiInference)generativeAiClient, properties.getOptions(), (ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP));
        observationConvention.ifAvailable(arg_0 -> ((OCICohereChatModel)chatModel).setObservationConvention(arg_0));
        return chatModel;
    }
}

