/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.google.genai.cache;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.genai.types.CachedContent;
import com.google.genai.types.CachedContentUsageMetadata;
import com.google.genai.types.Content;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.springframework.util.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class GoogleGenAiCachedContent {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="model")
    private final String model;
    @JsonProperty(value="display_name")
    private final String displayName;
    @JsonProperty(value="create_time")
    private final Instant createTime;
    @JsonProperty(value="update_time")
    private final Instant updateTime;
    @JsonProperty(value="expire_time")
    private final Instant expireTime;
    @JsonProperty(value="ttl")
    private final Duration ttl;
    @JsonProperty(value="contents")
    private final List<Content> contents;
    @JsonProperty(value="system_instruction")
    private final Content systemInstruction;
    @JsonProperty(value="usage_metadata")
    private final CachedContentUsageMetadata usageMetadata;

    private GoogleGenAiCachedContent(Builder builder) {
        this.name = builder.name;
        this.model = builder.model;
        this.displayName = builder.displayName;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.expireTime = builder.expireTime;
        this.ttl = builder.ttl;
        this.contents = builder.contents;
        this.systemInstruction = builder.systemInstruction;
        this.usageMetadata = builder.usageMetadata;
    }

    public static GoogleGenAiCachedContent from(CachedContent cachedContent) {
        if (cachedContent == null) {
            return null;
        }
        Builder builder = GoogleGenAiCachedContent.builder().name(cachedContent.name().orElse(null)).model(cachedContent.model().orElse(null)).displayName(cachedContent.displayName().orElse(null)).createTime(cachedContent.createTime().orElse(null)).updateTime(cachedContent.updateTime().orElse(null)).expireTime(cachedContent.expireTime().orElse(null));
        cachedContent.usageMetadata().ifPresent(builder::usageMetadata);
        return builder.build();
    }

    public String getName() {
        return this.name;
    }

    public String getModel() {
        return this.model;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public Instant getUpdateTime() {
        return this.updateTime;
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public Content getSystemInstruction() {
        return this.systemInstruction;
    }

    public CachedContentUsageMetadata getUsageMetadata() {
        return this.usageMetadata;
    }

    public boolean isExpired() {
        if (this.expireTime == null) {
            return false;
        }
        return Instant.now().isAfter(this.expireTime);
    }

    public Duration getRemainingTtl() {
        if (this.expireTime == null) {
            return null;
        }
        Duration remaining = Duration.between(Instant.now(), this.expireTime);
        return remaining.isNegative() ? Duration.ZERO : remaining;
    }

    public String toString() {
        return "GoogleGenAiCachedContent{name='" + this.name + "', model='" + this.model + "', displayName='" + this.displayName + "', expireTime=" + String.valueOf(this.expireTime) + ", ttl=" + String.valueOf(this.ttl) + ", isExpired=" + this.isExpired() + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String model;
        private String displayName;
        private Instant createTime;
        private Instant updateTime;
        private Instant expireTime;
        private Duration ttl;
        private List<Content> contents;
        private Content systemInstruction;
        private CachedContentUsageMetadata usageMetadata;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Builder expireTime(Instant expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public Builder ttl(Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder contents(List<Content> contents) {
            this.contents = contents;
            return this;
        }

        public Builder systemInstruction(Content systemInstruction) {
            this.systemInstruction = systemInstruction;
            return this;
        }

        public Builder usageMetadata(CachedContentUsageMetadata usageMetadata) {
            this.usageMetadata = usageMetadata;
            return this;
        }

        public GoogleGenAiCachedContent build() {
            Assert.hasText((String)this.model, (String)"Model must not be empty");
            return new GoogleGenAiCachedContent(this);
        }
    }
}

