/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import java.util.HashMap;
import java.util.Map;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.util.Assert;

public record ChatClientRequest(Prompt prompt, Map<String, Object> context) {
    public ChatClientRequest {
        Assert.notNull((Object)prompt, (String)"prompt cannot be null");
        Assert.notNull(context, (String)"context cannot be null");
        Assert.noNullElements(context.keySet(), (String)"context keys cannot be null");
    }

    public ChatClientRequest copy() {
        return new ChatClientRequest(this.prompt.copy(), new HashMap<String, Object>(this.context));
    }

    public Builder mutate() {
        return new Builder().prompt(this.prompt.copy()).context(new HashMap<String, Object>(this.context));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Prompt prompt;
        private Map<String, Object> context = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder prompt(Prompt prompt) {
            Assert.notNull((Object)prompt, (String)"prompt cannot be null");
            this.prompt = prompt;
            return this;
        }

        public Builder context(Map<String, Object> context) {
            Assert.notNull(context, (String)"context cannot be null");
            this.context.putAll(context);
            return this;
        }

        public Builder context(String key, Object value) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            this.context.put(key, value);
            return this;
        }

        public ChatClientRequest build() {
            return new ChatClientRequest(this.prompt, this.context);
        }
    }
}

